/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client;

import com.hazelcast.client.ClientEndpoint;
import com.hazelcast.client.ClientEngineImpl;
import com.hazelcast.client.ClientPrincipal;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.spi.AbstractOperation;
import com.hazelcast.spi.UrgentSystemOperation;
import java.io.IOException;
import java.util.Set;

public class ClientReAuthOperation
extends AbstractOperation
implements UrgentSystemOperation {
    private String clientUuid;

    public ClientReAuthOperation() {
    }

    public ClientReAuthOperation(String clientUuid) {
        this.clientUuid = clientUuid;
    }

    @Override
    public void run() throws Exception {
        ClientEngineImpl service = (ClientEngineImpl)this.getService();
        String memberUuid = this.getCallerUuid();
        ClientEngineImpl engine = (ClientEngineImpl)this.getService();
        Set<ClientEndpoint> endpoints = engine.getEndpointManager().getEndpoints(this.clientUuid);
        for (ClientEndpoint endpoint : endpoints) {
            ClientPrincipal principal = new ClientPrincipal(this.clientUuid, memberUuid);
            endpoint.authenticated(principal);
        }
        service.addOwnershipMapping(this.clientUuid, memberUuid);
    }

    @Override
    public boolean returnsResponse() {
        return false;
    }

    @Override
    public Object getResponse() {
        return Boolean.TRUE;
    }

    @Override
    public String getServiceName() {
        return "hz:core:clientEngine";
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeUTF(this.clientUuid);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.clientUuid = in.readUTF();
    }
}

