/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.wan.impl;

import com.hazelcast.config.WanReplicationConfig;
import com.hazelcast.config.WanTargetClusterConfig;
import com.hazelcast.instance.Node;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.ClassLoaderUtil;
import com.hazelcast.nio.Packet;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.ReplicationSupportingService;
import com.hazelcast.util.ExceptionUtil;
import com.hazelcast.wan.WanReplicationEndpoint;
import com.hazelcast.wan.WanReplicationEvent;
import com.hazelcast.wan.WanReplicationPublisher;
import com.hazelcast.wan.WanReplicationService;
import com.hazelcast.wan.impl.WanNoDelayReplication;
import com.hazelcast.wan.impl.WanReplicationPublisherDelegate;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class WanReplicationServiceImpl
implements WanReplicationService {
    private final Node node;
    private final ILogger logger;
    private final Map<String, WanReplicationPublisherDelegate> wanReplications = this.initializeWanReplicationPublisherMapping();

    public WanReplicationServiceImpl(Node node) {
        this.node = node;
        this.logger = node.getLogger(WanReplicationServiceImpl.class.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WanReplicationPublisher getWanReplicationPublisher(String name) {
        WanReplicationPublisherDelegate wr = this.wanReplications.get(name);
        if (wr != null) {
            return wr;
        }
        WanReplicationServiceImpl wanReplicationServiceImpl = this;
        synchronized (wanReplicationServiceImpl) {
            wr = this.wanReplications.get(name);
            if (wr != null) {
                return wr;
            }
            WanReplicationConfig wanReplicationConfig = this.node.getConfig().getWanReplicationConfig(name);
            if (wanReplicationConfig == null) {
                return null;
            }
            List<WanTargetClusterConfig> targets = wanReplicationConfig.getTargetClusterConfigs();
            WanReplicationEndpoint[] targetEndpoints = new WanReplicationEndpoint[targets.size()];
            int count = 0;
            for (WanTargetClusterConfig targetClusterConfig : targets) {
                WanReplicationEndpoint target;
                if (targetClusterConfig.getReplicationImpl() != null) {
                    try {
                        target = (WanReplicationEndpoint)ClassLoaderUtil.newInstance(this.node.getConfigClassLoader(), targetClusterConfig.getReplicationImpl());
                    }
                    catch (Exception e) {
                        throw ExceptionUtil.rethrow(e);
                    }
                } else {
                    target = new WanNoDelayReplication();
                }
                String groupName = targetClusterConfig.getGroupName();
                String password = targetClusterConfig.getGroupPassword();
                String[] addresses = new String[targetClusterConfig.getEndpoints().size()];
                targetClusterConfig.getEndpoints().toArray(addresses);
                target.init(this.node, groupName, password, addresses);
                targetEndpoints[count++] = target;
            }
            wr = new WanReplicationPublisherDelegate(name, targetEndpoints);
            this.wanReplications.put(name, wr);
            return wr;
        }
    }

    @Override
    public void handleEvent(final Packet packet) {
        this.node.nodeEngine.getExecutionService().execute("hz:wan", new Runnable(){

            @Override
            public void run() {
                Data data = packet.getData();
                try {
                    WanReplicationEvent replicationEvent = (WanReplicationEvent)((WanReplicationServiceImpl)WanReplicationServiceImpl.this).node.nodeEngine.toObject(data);
                    String serviceName = replicationEvent.getServiceName();
                    ReplicationSupportingService service = (ReplicationSupportingService)((WanReplicationServiceImpl)WanReplicationServiceImpl.this).node.nodeEngine.getService(serviceName);
                    service.onReplicationEvent(replicationEvent);
                }
                catch (Exception e) {
                    WanReplicationServiceImpl.this.logger.severe(e);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        WanReplicationServiceImpl wanReplicationServiceImpl = this;
        synchronized (wanReplicationServiceImpl) {
            for (WanReplicationPublisherDelegate wanReplication : this.wanReplications.values()) {
                WanReplicationEndpoint[] wanReplicationEndpoints = wanReplication.getEndpoints();
                if (wanReplicationEndpoints == null) continue;
                for (WanReplicationEndpoint wanReplicationEndpoint : wanReplicationEndpoints) {
                    if (wanReplicationEndpoint == null) continue;
                    wanReplicationEndpoint.shutdown();
                }
            }
            this.wanReplications.clear();
        }
    }

    private ConcurrentHashMap<String, WanReplicationPublisherDelegate> initializeWanReplicationPublisherMapping() {
        return new ConcurrentHashMap<String, WanReplicationPublisherDelegate>(2);
    }
}

