/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.spring.mongodb;

import com.hazelcast.spring.mongodb.MongoDBConverter;
import com.hazelcast.spring.mongodb.ValueWrapper;
import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import com.mongodb.Mongo;
import java.util.Date;
import java.util.UUID;
import java.util.regex.Pattern;
import org.bson.BSONObject;
import org.bson.types.ObjectId;
import org.springframework.data.mongodb.core.MongoTemplate;

public class SpringMongoDBConverter
implements MongoDBConverter {
    private static Class[] acceptedClazzArray = new Class[]{Date.class, Number.class, String.class, ObjectId.class, BSONObject.class, Boolean.class, Double.class, Integer.class, Long.class, Pattern.class, UUID.class};
    private MongoTemplate mongoTemplate;

    public SpringMongoDBConverter(Mongo mongo, String dbname) {
        this.mongoTemplate = new MongoTemplate(mongo, dbname);
    }

    public SpringMongoDBConverter(MongoTemplate mongoTemplate) {
        this.mongoTemplate = mongoTemplate;
    }

    @Override
    public DBObject toDBObject(Object obj) {
        BasicDBObject dbObject = new BasicDBObject();
        Object valueWrapper = SpringMongoDBConverter.getConvertedObject(obj);
        this.mongoTemplate.getConverter().write(valueWrapper, (Object)dbObject);
        return dbObject;
    }

    @Override
    public Object toObject(Class clazz, DBObject dbObject) {
        if (clazz.equals(ValueWrapper.class)) {
            return dbObject.get("value");
        }
        return this.mongoTemplate.getConverter().read(clazz, (Object)dbObject);
    }

    private static Object getConvertedObject(Object obj) {
        for (int i = 0; i < acceptedClazzArray.length; ++i) {
            if (!obj.getClass().isAssignableFrom(acceptedClazzArray[i])) continue;
            return new ValueWrapper(obj);
        }
        return obj;
    }
}

