/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.queue.tx;

import com.hazelcast.core.TransactionalQueue;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.queue.QueueService;
import com.hazelcast.queue.tx.TransactionalQueueProxySupport;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.transaction.impl.TransactionSupport;
import com.hazelcast.util.EmptyStatement;
import java.util.concurrent.TimeUnit;

public class TransactionalQueueProxy<E>
extends TransactionalQueueProxySupport
implements TransactionalQueue<E> {
    public TransactionalQueueProxy(NodeEngine nodeEngine, QueueService service, String name, TransactionSupport tx) {
        super(nodeEngine, service, name, tx);
    }

    @Override
    public boolean offer(E e) {
        try {
            return this.offer(e, 0L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException ignored) {
            EmptyStatement.ignore(ignored);
            return false;
        }
    }

    @Override
    public boolean offer(E e, long timeout, TimeUnit unit) throws InterruptedException {
        this.checkTransactionState();
        Data data = this.getNodeEngine().toData(e);
        return this.offerInternal(data, unit.toMillis(timeout));
    }

    @Override
    public E take() throws InterruptedException {
        return this.poll(-1L, TimeUnit.MILLISECONDS);
    }

    @Override
    public E poll() {
        try {
            return this.poll(0L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException ignored) {
            EmptyStatement.ignore(ignored);
            return null;
        }
    }

    @Override
    public E poll(long timeout, TimeUnit unit) throws InterruptedException {
        this.checkTransactionState();
        Data data = this.pollInternal(unit.toMillis(timeout));
        return (E)this.getNodeEngine().toObject(data);
    }

    @Override
    public E peek() {
        try {
            return this.peek(0L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException ignored) {
            EmptyStatement.ignore(ignored);
            return null;
        }
    }

    @Override
    public E peek(long timeout, TimeUnit unit) throws InterruptedException {
        this.checkTransactionState();
        Data data = this.peekInternal(unit.toMillis(timeout));
        return (E)this.getNodeEngine().toObject(data);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("TransactionalQueue{");
        sb.append("name=").append(this.name);
        sb.append('}');
        return sb.toString();
    }
}

