/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.queue.client;

import com.hazelcast.client.CallableClientRequest;
import com.hazelcast.client.ClientEndpoint;
import com.hazelcast.client.RetryableRequest;
import com.hazelcast.client.SecureRequest;
import com.hazelcast.core.ItemEvent;
import com.hazelcast.core.ItemListener;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import com.hazelcast.queue.QueuePortableHook;
import com.hazelcast.queue.QueueService;
import com.hazelcast.security.permission.QueuePermission;
import com.hazelcast.spi.impl.PortableItemEvent;
import java.io.IOException;
import java.security.Permission;

public class AddListenerRequest
extends CallableClientRequest
implements SecureRequest,
RetryableRequest {
    private String name;
    private boolean includeValue;

    public AddListenerRequest() {
    }

    public AddListenerRequest(String name, boolean includeValue) {
        this.name = name;
        this.includeValue = includeValue;
    }

    @Override
    public String getServiceName() {
        return "hz:impl:queueService";
    }

    @Override
    public int getFactoryId() {
        return QueuePortableHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 12;
    }

    @Override
    public void write(PortableWriter writer) throws IOException {
        writer.writeUTF("n", this.name);
        writer.writeBoolean("i", this.includeValue);
    }

    @Override
    public void read(PortableReader reader) throws IOException {
        this.name = reader.readUTF("n");
        this.includeValue = reader.readBoolean("i");
    }

    public Object call() throws Exception {
        final ClientEndpoint endpoint = this.getEndpoint();
        QueueService service = (QueueService)this.getService();
        ItemListener listener = new ItemListener(){

            public void itemAdded(ItemEvent item) {
                this.send(item);
            }

            public void itemRemoved(ItemEvent item) {
                this.send(item);
            }

            private void send(ItemEvent event) {
                if (endpoint.live()) {
                    Data item = AddListenerRequest.this.serializationService.toData(event.getItem());
                    PortableItemEvent portableItemEvent = new PortableItemEvent(item, event.getEventType(), event.getMember().getUuid());
                    endpoint.sendEvent(portableItemEvent, AddListenerRequest.this.getCallId());
                }
            }
        };
        String registrationId = service.addItemListener(this.name, listener, this.includeValue);
        endpoint.setListenerRegistration("hz:impl:queueService", this.name, registrationId);
        return registrationId;
    }

    @Override
    public Permission getRequiredPermission() {
        return new QueuePermission(this.name, "listen");
    }
}

