/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.nio.serialization;

import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.DataSerializable;
import com.hazelcast.nio.serialization.FieldDefinition;
import com.hazelcast.nio.serialization.FieldType;
import java.io.IOException;

class FieldDefinitionImpl
implements DataSerializable,
FieldDefinition {
    int index;
    String fieldName;
    FieldType type;
    int classId;
    int factoryId;
    int version = -1;

    FieldDefinitionImpl() {
    }

    FieldDefinitionImpl(int index, String fieldName, FieldType type) {
        this(index, fieldName, type, 0, 0, -1);
    }

    FieldDefinitionImpl(int index, String fieldName, FieldType type, int factoryId, int classId, int version) {
        this.classId = classId;
        this.type = type;
        this.fieldName = fieldName;
        this.index = index;
        this.factoryId = factoryId;
        this.version = version;
    }

    @Override
    public FieldType getType() {
        return this.type;
    }

    @Override
    public String getName() {
        return this.fieldName;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public int getFactoryId() {
        return this.factoryId;
    }

    @Override
    public int getClassId() {
        return this.classId;
    }

    @Override
    public int getVersion() {
        return this.version;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeInt(this.index);
        out.writeUTF(this.fieldName);
        out.writeByte(this.type.getId());
        out.writeInt(this.factoryId);
        out.writeInt(this.classId);
        out.writeInt(this.version);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.index = in.readInt();
        this.fieldName = in.readUTF();
        this.type = FieldType.get(in.readByte());
        this.factoryId = in.readInt();
        this.classId = in.readInt();
        this.version = in.readInt();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FieldDefinitionImpl that = (FieldDefinitionImpl)o;
        if (this.classId != that.classId) {
            return false;
        }
        if (this.factoryId != that.factoryId) {
            return false;
        }
        if (this.version != that.version) {
            return false;
        }
        if (this.fieldName != null ? !this.fieldName.equals(that.fieldName) : that.fieldName != null) {
            return false;
        }
        return this.type == that.type;
    }

    public int hashCode() {
        int result = this.fieldName != null ? this.fieldName.hashCode() : 0;
        result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
        result = 31 * result + this.classId;
        result = 31 * result + this.factoryId;
        result = 31 * result + this.version;
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("FieldDefinitionImpl{");
        sb.append("index=").append(this.index);
        sb.append(", fieldName='").append(this.fieldName).append('\'');
        sb.append(", type=").append((Object)this.type);
        sb.append(", classId=").append(this.classId);
        sb.append(", factoryId=").append(this.factoryId);
        sb.append(", version=").append(this.version);
        sb.append('}');
        return sb.toString();
    }
}

