/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.nio.serialization;

import com.hazelcast.nio.BufferObjectDataInput;
import com.hazelcast.nio.IOUtil;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.serialization.ClassDefinition;
import com.hazelcast.nio.serialization.FieldDefinition;
import com.hazelcast.nio.serialization.FieldType;
import com.hazelcast.nio.serialization.HazelcastSerializationException;
import com.hazelcast.nio.serialization.Portable;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableSerializer;
import java.io.IOException;
import java.util.Set;

public class DefaultPortableReader
implements PortableReader {
    protected final ClassDefinition cd;
    private final PortableSerializer serializer;
    private final BufferObjectDataInput in;
    private final int finalPosition;
    private final int offset;
    private boolean raw;

    public DefaultPortableReader(PortableSerializer serializer, BufferObjectDataInput in, ClassDefinition cd) {
        this.in = in;
        this.serializer = serializer;
        this.cd = cd;
        try {
            this.finalPosition = in.readInt();
        }
        catch (IOException e) {
            throw new HazelcastSerializationException(e);
        }
        this.offset = in.position();
    }

    @Override
    public int getVersion() {
        return this.cd.getVersion();
    }

    @Override
    public boolean hasField(String fieldName) {
        return this.cd.hasField(fieldName);
    }

    @Override
    public Set<String> getFieldNames() {
        return this.cd.getFieldNames();
    }

    @Override
    public FieldType getFieldType(String fieldName) {
        return this.cd.getFieldType(fieldName);
    }

    @Override
    public int getFieldClassId(String fieldName) {
        return this.cd.getFieldClassId(fieldName);
    }

    public int getFieldVersion(String fieldName) {
        return this.cd.getFieldVersion(fieldName);
    }

    @Override
    public int readInt(String fieldName) throws IOException {
        int pos = this.getPosition(fieldName);
        return this.in.readInt(pos);
    }

    @Override
    public long readLong(String fieldName) throws IOException {
        int pos = this.getPosition(fieldName);
        return this.in.readLong(pos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String readUTF(String fieldName) throws IOException {
        int currentPos = this.in.position();
        try {
            int pos = this.getPosition(fieldName);
            this.in.position(pos);
            String string = this.in.readUTF();
            return string;
        }
        finally {
            this.in.position(currentPos);
        }
    }

    @Override
    public boolean readBoolean(String fieldName) throws IOException {
        int pos = this.getPosition(fieldName);
        return this.in.readBoolean(pos);
    }

    @Override
    public byte readByte(String fieldName) throws IOException {
        int pos = this.getPosition(fieldName);
        return this.in.readByte(pos);
    }

    @Override
    public char readChar(String fieldName) throws IOException {
        int pos = this.getPosition(fieldName);
        return this.in.readChar(pos);
    }

    @Override
    public double readDouble(String fieldName) throws IOException {
        int pos = this.getPosition(fieldName);
        return this.in.readDouble(pos);
    }

    @Override
    public float readFloat(String fieldName) throws IOException {
        int pos = this.getPosition(fieldName);
        return this.in.readFloat(pos);
    }

    @Override
    public short readShort(String fieldName) throws IOException {
        int pos = this.getPosition(fieldName);
        return this.in.readShort(pos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] readByteArray(String fieldName) throws IOException {
        int currentPos = this.in.position();
        try {
            int pos = this.getPosition(fieldName);
            this.in.position(pos);
            byte[] byArray = IOUtil.readByteArray(this.in);
            return byArray;
        }
        finally {
            this.in.position(currentPos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public char[] readCharArray(String fieldName) throws IOException {
        int currentPos = this.in.position();
        try {
            int pos = this.getPosition(fieldName);
            this.in.position(pos);
            char[] cArray = this.in.readCharArray();
            return cArray;
        }
        finally {
            this.in.position(currentPos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[] readIntArray(String fieldName) throws IOException {
        int currentPos = this.in.position();
        try {
            int pos = this.getPosition(fieldName);
            this.in.position(pos);
            int[] nArray = this.in.readIntArray();
            return nArray;
        }
        finally {
            this.in.position(currentPos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long[] readLongArray(String fieldName) throws IOException {
        int currentPos = this.in.position();
        try {
            int pos = this.getPosition(fieldName);
            this.in.position(pos);
            long[] lArray = this.in.readLongArray();
            return lArray;
        }
        finally {
            this.in.position(currentPos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double[] readDoubleArray(String fieldName) throws IOException {
        int currentPos = this.in.position();
        try {
            int pos = this.getPosition(fieldName);
            this.in.position(pos);
            double[] dArray = this.in.readDoubleArray();
            return dArray;
        }
        finally {
            this.in.position(currentPos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public float[] readFloatArray(String fieldName) throws IOException {
        int currentPos = this.in.position();
        try {
            int pos = this.getPosition(fieldName);
            this.in.position(pos);
            float[] fArray = this.in.readFloatArray();
            return fArray;
        }
        finally {
            this.in.position(currentPos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public short[] readShortArray(String fieldName) throws IOException {
        int currentPos = this.in.position();
        try {
            int pos = this.getPosition(fieldName);
            this.in.position(pos);
            short[] sArray = this.in.readShortArray();
            return sArray;
        }
        finally {
            this.in.position(currentPos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Portable readPortable(String fieldName) throws IOException {
        FieldDefinition fd = this.cd.get(fieldName);
        if (fd == null) {
            throw this.throwUnknownFieldException(fieldName);
        }
        int currentPos = this.in.position();
        try {
            int pos = this.getPosition(fd);
            this.in.position(pos);
            boolean isNull = this.in.readBoolean();
            if (!isNull) {
                Portable portable = this.serializer.readAndInitialize(this.in, fd.getFactoryId(), fd.getClassId(), fd.getVersion());
                return portable;
            }
            Portable portable = null;
            return portable;
        }
        finally {
            this.in.position(currentPos);
        }
    }

    private HazelcastSerializationException throwUnknownFieldException(String fieldName) {
        return new HazelcastSerializationException("Unknown field name: '" + fieldName + "' for ClassDefinition {id: " + this.cd.getClassId() + ", version: " + this.cd.getVersion() + "}");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Portable[] readPortableArray(String fieldName) throws IOException {
        FieldDefinition fd = this.cd.get(fieldName);
        if (fd == null) {
            throw this.throwUnknownFieldException(fieldName);
        }
        int currentPos = this.in.position();
        try {
            int pos = this.getPosition(fd);
            this.in.position(pos);
            int len = this.in.readInt();
            Portable[] portables = new Portable[len];
            if (len > 0) {
                int offset = this.in.position();
                for (int i = 0; i < len; ++i) {
                    int start = this.in.readInt(offset + i * 4);
                    this.in.position(start);
                    portables[i] = this.serializer.readAndInitialize(this.in, fd.getFactoryId(), fd.getClassId(), fd.getVersion());
                }
            }
            Portable[] portableArray = portables;
            return portableArray;
        }
        finally {
            this.in.position(currentPos);
        }
    }

    protected int getPosition(String fieldName) throws IOException {
        if (this.raw) {
            throw new HazelcastSerializationException("Cannot read Portable fields after getRawDataInput() is called!");
        }
        FieldDefinition fd = this.cd.get(fieldName);
        if (fd == null) {
            throw this.throwUnknownFieldException(fieldName);
        }
        return this.getPosition(fd);
    }

    protected int getPosition(FieldDefinition fd) throws IOException {
        return this.in.readInt(this.offset + fd.getIndex() * 4);
    }

    @Override
    public ObjectDataInput getRawDataInput() throws IOException {
        if (!this.raw) {
            int pos = this.in.readInt(this.offset + this.cd.getFieldCount() * 4);
            this.in.position(pos);
        }
        this.raw = true;
        return this.in;
    }

    void end() throws IOException {
        this.in.position(this.finalPosition);
    }
}

