/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.nio.ascii;

import com.hazelcast.ascii.CommandParser;
import com.hazelcast.ascii.TextCommand;
import com.hazelcast.ascii.TextCommandConstants;
import com.hazelcast.ascii.TextCommandService;
import com.hazelcast.ascii.memcache.DeleteCommandParser;
import com.hazelcast.ascii.memcache.ErrorCommand;
import com.hazelcast.ascii.memcache.GetCommandParser;
import com.hazelcast.ascii.memcache.IncrementCommandParser;
import com.hazelcast.ascii.memcache.SetCommandParser;
import com.hazelcast.ascii.memcache.SimpleCommandParser;
import com.hazelcast.ascii.memcache.TouchCommandParser;
import com.hazelcast.ascii.rest.HttpCommand;
import com.hazelcast.ascii.rest.HttpDeleteCommandParser;
import com.hazelcast.ascii.rest.HttpGetCommandParser;
import com.hazelcast.ascii.rest.HttpPostCommandParser;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.ConnectionType;
import com.hazelcast.nio.IOService;
import com.hazelcast.nio.ascii.SocketTextWriter;
import com.hazelcast.nio.tcp.SocketReader;
import com.hazelcast.nio.tcp.TcpIpConnection;
import com.hazelcast.util.StringUtil;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;

public class SocketTextReader
implements TextCommandConstants,
SocketReader {
    private static final Map<String, CommandParser> MAP_COMMAND_PARSERS = new HashMap<String, CommandParser>();
    private static final int CAPACITY = 500;
    private ByteBuffer commandLine = ByteBuffer.allocate(500);
    private boolean commandLineRead;
    private TextCommand command;
    private final TextCommandService textCommandService;
    private final SocketTextWriter socketTextWriter;
    private final TcpIpConnection connection;
    private final boolean restEnabled;
    private final boolean memcacheEnabled;
    private boolean connectionTypeSet;
    private long requestIdGen;
    private final ILogger logger;

    public SocketTextReader(TcpIpConnection connection) {
        IOService ioService = connection.getConnectionManager().getIOHandler();
        this.textCommandService = ioService.getTextCommandService();
        this.socketTextWriter = (SocketTextWriter)connection.getWriteHandler().getSocketWriter();
        this.connection = connection;
        this.memcacheEnabled = ioService.isMemcacheEnabled();
        this.restEnabled = ioService.isRestEnabled();
        this.logger = ioService.getLogger(this.getClass().getName());
    }

    public void sendResponse(TextCommand command) {
        this.socketTextWriter.enqueue(command);
    }

    @Override
    public void read(ByteBuffer inBuffer) {
        while (inBuffer.hasRemaining()) {
            this.doRead(inBuffer);
        }
    }

    private void doRead(ByteBuffer bb) {
        while (!this.commandLineRead && bb.hasRemaining()) {
            byte b = bb.get();
            char c = (char)b;
            if (c == '\n') {
                this.commandLineRead = true;
                continue;
            }
            if (c == '\r') continue;
            this.commandLine.put(b);
        }
        if (this.commandLineRead) {
            if (this.command == null) {
                this.processCmd(SocketTextReader.toStringAndClear(this.commandLine));
            }
            if (this.command != null) {
                boolean complete = this.command.readFrom(bb);
                if (complete) {
                    this.publishRequest(this.command);
                    this.reset();
                }
            } else {
                this.reset();
            }
        }
    }

    void reset() {
        this.command = null;
        this.commandLine.clear();
        this.commandLineRead = false;
    }

    public static String toStringAndClear(ByteBuffer bb) {
        if (bb == null) {
            return "";
        }
        String result = bb.position() == 0 ? "" : StringUtil.bytesToString(bb.array(), 0, bb.position());
        bb.clear();
        return result;
    }

    public void publishRequest(TextCommand command) {
        long l;
        if (!this.connectionTypeSet) {
            if (command instanceof HttpCommand) {
                if (!this.restEnabled) {
                    this.connection.close();
                }
                this.connection.setType(ConnectionType.REST_CLIENT);
            } else {
                if (!this.memcacheEnabled) {
                    this.connection.close();
                }
                this.connection.setType(ConnectionType.MEMCACHE_CLIENT);
            }
            this.connectionTypeSet = true;
        }
        if (command.shouldReply()) {
            long l2 = this.requestIdGen;
            l = l2;
            this.requestIdGen = l2 + 1L;
        } else {
            l = -1L;
        }
        long requestId = l;
        command.init(this, requestId);
        this.textCommandService.processRequest(command);
    }

    void processCmd(String cmd) {
        try {
            int space = cmd.indexOf(32);
            String operation = space == -1 ? cmd : cmd.substring(0, space);
            CommandParser commandParser = MAP_COMMAND_PARSERS.get(operation);
            this.command = commandParser != null ? commandParser.parser(this, cmd, space) : new ErrorCommand(TextCommandConstants.TextCommandType.UNKNOWN);
        }
        catch (Throwable t) {
            this.logger.finest(t);
            this.command = new ErrorCommand(TextCommandConstants.TextCommandType.ERROR_CLIENT, "Invalid command : " + cmd);
        }
    }

    public SocketTextWriter getSocketTextWriter() {
        return this.socketTextWriter;
    }

    public void closeConnection() {
        this.connection.close();
    }

    static {
        MAP_COMMAND_PARSERS.put("get", new GetCommandParser());
        MAP_COMMAND_PARSERS.put("gets", new GetCommandParser());
        MAP_COMMAND_PARSERS.put("set", new SetCommandParser(TextCommandConstants.TextCommandType.SET));
        MAP_COMMAND_PARSERS.put("add", new SetCommandParser(TextCommandConstants.TextCommandType.ADD));
        MAP_COMMAND_PARSERS.put("replace", new SetCommandParser(TextCommandConstants.TextCommandType.REPLACE));
        MAP_COMMAND_PARSERS.put("append", new SetCommandParser(TextCommandConstants.TextCommandType.APPEND));
        MAP_COMMAND_PARSERS.put("prepend", new SetCommandParser(TextCommandConstants.TextCommandType.PREPEND));
        MAP_COMMAND_PARSERS.put("touch", new TouchCommandParser(TextCommandConstants.TextCommandType.TOUCH));
        MAP_COMMAND_PARSERS.put("incr", new IncrementCommandParser(TextCommandConstants.TextCommandType.INCREMENT));
        MAP_COMMAND_PARSERS.put("decr", new IncrementCommandParser(TextCommandConstants.TextCommandType.DECREMENT));
        MAP_COMMAND_PARSERS.put("delete", new DeleteCommandParser());
        MAP_COMMAND_PARSERS.put("quit", new SimpleCommandParser(TextCommandConstants.TextCommandType.QUIT));
        MAP_COMMAND_PARSERS.put("stats", new SimpleCommandParser(TextCommandConstants.TextCommandType.STATS));
        MAP_COMMAND_PARSERS.put("version", new SimpleCommandParser(TextCommandConstants.TextCommandType.VERSION));
        MAP_COMMAND_PARSERS.put("GET", new HttpGetCommandParser());
        MAP_COMMAND_PARSERS.put("POST", new HttpPostCommandParser());
        MAP_COMMAND_PARSERS.put("PUT", new HttpPostCommandParser());
        MAP_COMMAND_PARSERS.put("DELETE", new HttpDeleteCommandParser());
    }
}

