/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.writebehind;

import com.hazelcast.map.writebehind.BoundedArrayWriteBehindQueue;
import com.hazelcast.map.writebehind.SynchronizedWriteBehindQueue;
import com.hazelcast.map.writebehind.WriteBehindQueue;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

public final class WriteBehindQueues {
    private WriteBehindQueues() {
    }

    public static <T> WriteBehindQueue<T> createBoundedArrayWriteBehindQueue(int maxSizePerNode, AtomicInteger counter) {
        return new BoundedArrayWriteBehindQueue(maxSizePerNode, counter);
    }

    public static <T> WriteBehindQueue<T> createDefaultWriteBehindQueue(int maxSizePerNode, AtomicInteger counter) {
        return WriteBehindQueues.createSafeWriteBehindQueue(WriteBehindQueues.createBoundedArrayWriteBehindQueue(maxSizePerNode, counter));
    }

    public static <T> WriteBehindQueue<T> emptyWriteBehindQueue() {
        return EmptyWriteBehindQueueHolder.EMPTY_WRITE_BEHIND_QUEUE;
    }

    public static <T> WriteBehindQueue<T> createSafeWriteBehindQueue(WriteBehindQueue<T> queue) {
        return new SynchronizedWriteBehindQueue<T>(queue);
    }

    private static final class EmptyWriteBehindQueue<T>
    implements WriteBehindQueue<T> {
        private EmptyWriteBehindQueue() {
        }

        @Override
        public boolean offer(T t) {
            return false;
        }

        @Override
        public void removeFirst() {
        }

        @Override
        public T get(int index) {
            throw new IndexOutOfBoundsException("Index: " + index);
        }

        @Override
        public T remove(int index) {
            return null;
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public void clear() {
        }

        @Override
        public WriteBehindQueue<T> getSnapShot() {
            return WriteBehindQueues.emptyWriteBehindQueue();
        }

        @Override
        public void addFront(Collection collection) {
        }

        @Override
        public void addEnd(Collection collection) {
        }

        @Override
        public List removeAll() {
            return Collections.emptyList();
        }

        @Override
        public boolean isEnabled() {
            return false;
        }

        @Override
        public List asList() {
            return Collections.emptyList();
        }

        @Override
        public void shrink() {
        }
    }

    private static final class EmptyWriteBehindQueueHolder {
        private static final WriteBehindQueue EMPTY_WRITE_BEHIND_QUEUE = new EmptyWriteBehindQueue();

        private EmptyWriteBehindQueueHolder() {
        }
    }
}

