/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.writebehind;

import com.hazelcast.config.MapStoreConfig;
import com.hazelcast.map.MapService;
import com.hazelcast.map.MapStoreWrapper;
import com.hazelcast.map.writebehind.WriteBehindManager;
import com.hazelcast.map.writebehind.WriteBehindQueue;
import com.hazelcast.map.writebehind.WriteBehindQueueManager;
import com.hazelcast.map.writebehind.store.StoreListener;
import com.hazelcast.nio.serialization.Data;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.ScheduledExecutorService;

public final class WriteBehindManagers {
    private WriteBehindManagers() {
    }

    public static WriteBehindManager createWriteBehindManager(String mapName, MapService service, MapStoreWrapper storeWrapper, MapStoreConfig mapStoreConfig) {
        return new WriteBehindQueueManager(mapName, service, storeWrapper, mapStoreConfig);
    }

    public static WriteBehindManager emptyWriteBehindManager() {
        return EmptyWriteBehindQueueManagerHolder.EMPTY_WRITE_BEHIND_QUEUE_MANAGER;
    }

    private static class EmptyWriteBehindQueueManager
    implements WriteBehindManager {
        private EmptyWriteBehindQueueManager() {
        }

        @Override
        public void start() {
        }

        @Override
        public void stop() {
        }

        @Override
        public void addStoreListener(StoreListener storeListener) {
        }

        @Override
        public ScheduledExecutorService getScheduler() {
            throw new UnsupportedOperationException();
        }

        public Collection<Data> flush(WriteBehindQueue queue) {
            return Collections.emptyList();
        }
    }

    private static final class EmptyWriteBehindQueueManagerHolder {
        private static final WriteBehindManager EMPTY_WRITE_BEHIND_QUEUE_MANAGER = new EmptyWriteBehindQueueManager();

        private EmptyWriteBehindQueueManagerHolder() {
        }
    }
}

