/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.writebehind;

import com.hazelcast.map.writebehind.ArrayWriteBehindQueue;
import com.hazelcast.map.writebehind.ReachedMaxSizeException;
import com.hazelcast.map.writebehind.WriteBehindQueue;
import com.hazelcast.map.writebehind.WriteBehindQueues;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

class BoundedArrayWriteBehindQueue<T>
extends ArrayWriteBehindQueue<T> {
    private final AtomicInteger writeBehindQueueItemCounter;
    private final int maxSize;

    BoundedArrayWriteBehindQueue(int maxSize, AtomicInteger writeBehindQueueItemCounter) {
        this.maxSize = maxSize;
        this.writeBehindQueueItemCounter = writeBehindQueueItemCounter;
    }

    BoundedArrayWriteBehindQueue(List<T> list, int maxSize, AtomicInteger writeBehindQueueItemCounter) {
        super(list);
        this.maxSize = maxSize;
        this.writeBehindQueueItemCounter = writeBehindQueueItemCounter;
    }

    @Override
    public boolean offer(T t) {
        int currentPerNodeCount = this.currentPerNodeCount();
        if (this.hasReachedMaxSize(currentPerNodeCount)) {
            throw new ReachedMaxSizeException("Queue already reached per node max capacity [" + this.maxSize + "]");
        }
        this.incrementPerNodeMaxSize();
        return super.offer(t);
    }

    @Override
    public void removeFirst() {
        super.removeFirst();
        this.decrementPerNodeMaxSize();
    }

    @Override
    public T remove(int index) {
        Object removed = super.remove(index);
        this.decrementPerNodeMaxSize();
        return removed;
    }

    @Override
    public List<T> removeAll() {
        List removes = super.removeAll();
        int size = removes.size();
        this.decrementPerNodeMaxSize(size);
        return removes;
    }

    @Override
    public void clear() {
        int size = this.size();
        super.clear();
        this.decrementPerNodeMaxSize(size);
    }

    @Override
    public WriteBehindQueue<T> getSnapShot() {
        if (this.list == null || this.list.isEmpty()) {
            return WriteBehindQueues.emptyWriteBehindQueue();
        }
        return new BoundedArrayWriteBehindQueue(new ArrayList(this.list), this.maxSize, this.writeBehindQueueItemCounter);
    }

    @Override
    public void addFront(Collection<T> collection) {
        int size;
        if (collection == null || collection.isEmpty()) {
            return;
        }
        int currentPerNodeCount = this.currentPerNodeCount();
        int desiredSize = currentPerNodeCount + (size = collection.size());
        if (this.hasReachedMaxSize(desiredSize)) {
            throw new ReachedMaxSizeException("Remaining per node space is not enough for this collection. Remaining = [" + (this.maxSize - currentPerNodeCount) + "]");
        }
        this.incrementPerNodeMaxSize(size);
        super.addFront(collection);
    }

    @Override
    public void addEnd(Collection<T> collection) {
        int size;
        if (collection == null || collection.isEmpty()) {
            return;
        }
        int currentPerNodeCount = this.currentPerNodeCount();
        int desiredSize = currentPerNodeCount + (size = collection.size());
        if (this.hasReachedMaxSize(desiredSize)) {
            throw new ReachedMaxSizeException("Remaining per node space is not enough for this collection. Remaining = [" + (this.maxSize - currentPerNodeCount) + "]");
        }
        this.incrementPerNodeMaxSize(size);
        super.addEnd(collection);
    }

    private boolean hasReachedMaxSize(int size) {
        return size >= this.maxSize;
    }

    private int currentPerNodeCount() {
        return this.writeBehindQueueItemCounter.intValue();
    }

    private void incrementPerNodeMaxSize() {
        this.writeBehindQueueItemCounter.incrementAndGet();
    }

    private void incrementPerNodeMaxSize(int count) {
        this.writeBehindQueueItemCounter.addAndGet(count);
    }

    private void decrementPerNodeMaxSize() {
        this.writeBehindQueueItemCounter.decrementAndGet();
    }

    private void decrementPerNodeMaxSize(int size) {
        this.writeBehindQueueItemCounter.addAndGet(-size);
    }
}

