/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.operation;

import com.hazelcast.core.MemberLeftException;
import com.hazelcast.map.MapService;
import com.hazelcast.map.PartitionContainer;
import com.hazelcast.map.QueryResult;
import com.hazelcast.map.RecordStore;
import com.hazelcast.map.operation.AbstractMapOperation;
import com.hazelcast.map.record.Record;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.SerializationService;
import com.hazelcast.query.PagingPredicate;
import com.hazelcast.query.Predicate;
import com.hazelcast.query.impl.IndexService;
import com.hazelcast.query.impl.QueryEntry;
import com.hazelcast.query.impl.QueryResultEntryImpl;
import com.hazelcast.query.impl.QueryableEntry;
import com.hazelcast.spi.ExceptionAction;
import com.hazelcast.spi.exception.TargetNotMemberException;
import com.hazelcast.util.SortingUtil;
import com.hazelcast.util.executor.ManagedExecutorService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public class QueryOperation
extends AbstractMapOperation {
    Predicate predicate;
    QueryResult result;
    PagingPredicate pagingPredicate;

    public QueryOperation(String mapName, Predicate predicate) {
        super(mapName);
        this.predicate = predicate;
        if (predicate instanceof PagingPredicate) {
            this.pagingPredicate = (PagingPredicate)predicate;
        }
    }

    public QueryOperation() {
    }

    @Override
    public void run() throws Exception {
        List<Integer> initialPartitions = this.mapService.getOwnedPartitions();
        IndexService indexService = this.mapService.getMapContainer(this.name).getIndexService();
        Set<QueryableEntry> entries = null;
        if (!this.getNodeEngine().getPartitionService().hasOnGoingMigration()) {
            entries = indexService.query(this.predicate);
        }
        this.result = new QueryResult();
        if (entries != null) {
            for (QueryableEntry entry : entries) {
                this.result.add(new QueryResultEntryImpl(entry.getKeyData(), entry.getKeyData(), entry.getValueData()));
            }
        } else if (this.pagingPredicate != null) {
            this.runParallelForPaging(initialPartitions);
        } else {
            this.runParallel(initialPartitions);
        }
        List<Integer> finalPartitions = this.mapService.getOwnedPartitions();
        if (initialPartitions.equals(finalPartitions)) {
            this.result.setPartitionIds(finalPartitions);
        }
        if (this.mapContainer.getMapConfig().isStatisticsEnabled()) {
            ((MapService)this.getService()).getLocalMapStatsImpl(this.name).incrementOtherOperations();
        }
    }

    protected void runParallel(List<Integer> initialPartitions) throws InterruptedException, ExecutionException {
        SerializationService ss = this.getNodeEngine().getSerializationService();
        ManagedExecutorService executor = this.getNodeEngine().getExecutionService().getExecutor("hz:query");
        ArrayList<Future<Collection<QueryableEntry>>> lsFutures = new ArrayList<Future<Collection<QueryableEntry>>>(initialPartitions.size());
        for (Integer n : initialPartitions) {
            Future<Collection<QueryableEntry>> f = executor.submit(new PartitionCallable(ss, n, null));
            lsFutures.add(f);
        }
        for (Future future : lsFutures) {
            Collection collection = (Collection)future.get();
            if (collection == null) continue;
            for (QueryableEntry entry : collection) {
                this.result.add(new QueryResultEntryImpl(entry.getKeyData(), entry.getKeyData(), entry.getValueData()));
            }
        }
    }

    protected void runParallelForPaging(List<Integer> initialPartitions) throws InterruptedException, ExecutionException {
        SerializationService ss = this.getNodeEngine().getSerializationService();
        ManagedExecutorService executor = this.getNodeEngine().getExecutionService().getExecutor("hz:query");
        ArrayList<Future<Collection<QueryableEntry>>> lsFutures = new ArrayList<Future<Collection<QueryableEntry>>>(initialPartitions.size());
        Comparator<Map.Entry> wrapperComparator = SortingUtil.newComparator(this.pagingPredicate);
        for (Integer partition : initialPartitions) {
            Future<Collection<QueryableEntry>> future = executor.submit(new PartitionCallable(ss, partition, wrapperComparator));
            lsFutures.add(future);
        }
        List toMerge = new LinkedList();
        for (Future future : lsFutures) {
            Collection collection = (Collection)future.get();
            toMerge.addAll(collection);
        }
        Collections.sort(toMerge, wrapperComparator);
        if (toMerge.size() > this.pagingPredicate.getPageSize()) {
            toMerge = toMerge.subList(0, this.pagingPredicate.getPageSize());
        }
        for (QueryableEntry queryableEntry : toMerge) {
            this.result.add(new QueryResultEntryImpl(queryableEntry.getKeyData(), queryableEntry.getKeyData(), queryableEntry.getValueData()));
        }
    }

    @Override
    public ExceptionAction onException(Throwable throwable) {
        if (throwable instanceof MemberLeftException) {
            return ExceptionAction.THROW_EXCEPTION;
        }
        if (throwable instanceof TargetNotMemberException) {
            return ExceptionAction.THROW_EXCEPTION;
        }
        return super.onException(throwable);
    }

    @Override
    public Object getResponse() {
        return this.result;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeUTF(this.name);
        out.writeObject(this.predicate);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.name = in.readUTF();
        this.predicate = (Predicate)in.readObject();
        if (this.predicate instanceof PagingPredicate) {
            this.pagingPredicate = (PagingPredicate)this.predicate;
        }
    }

    private class PartitionCallable
    implements Callable<Collection<QueryableEntry>> {
        int partition;
        SerializationService ss;
        Comparator<Map.Entry> wrapperComparator;

        private PartitionCallable(SerializationService ss, int partition, Comparator<Map.Entry> wrapperComparator) {
            this.ss = ss;
            this.partition = partition;
            this.wrapperComparator = wrapperComparator;
        }

        @Override
        public Collection<QueryableEntry> call() throws Exception {
            PartitionContainer container = QueryOperation.this.mapService.getPartitionContainer(this.partition);
            RecordStore recordStore = container.getRecordStore(QueryOperation.this.name);
            LinkedList<QueryableEntry> partitionResult = new LinkedList<QueryableEntry>();
            for (Record record : recordStore.getReadonlyRecordMapByWaitingMapStoreLoad().values()) {
                QueryEntry queryEntry;
                Data key = record.getKey();
                Object value = record.getCachedValue();
                if (value == Record.NOT_CACHED) {
                    value = record.getValue();
                    if (value != null && value instanceof Data) {
                        value = this.ss.toObject(value);
                    }
                } else {
                    value = this.ss.toObject(record.getValue());
                    record.setCachedValue(value);
                }
                if (value == null || !QueryOperation.this.predicate.apply(queryEntry = new QueryEntry(this.ss, key, key, value))) continue;
                if (QueryOperation.this.pagingPredicate != null) {
                    Map.Entry anchor = QueryOperation.this.pagingPredicate.getAnchor();
                    Comparator<Map.Entry> comparator = QueryOperation.this.pagingPredicate.getComparator();
                    if (anchor != null && SortingUtil.compare(comparator, QueryOperation.this.pagingPredicate.getIterationType(), anchor, queryEntry) >= 0) continue;
                }
                partitionResult.add(queryEntry);
            }
            if (QueryOperation.this.pagingPredicate != null) {
                Collections.sort(partitionResult, this.wrapperComparator);
                if (partitionResult.size() > QueryOperation.this.pagingPredicate.getPageSize()) {
                    return partitionResult.subList(0, QueryOperation.this.pagingPredicate.getPageSize());
                }
            }
            return partitionResult;
        }
    }
}

