/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.eviction;

import com.hazelcast.map.eviction.ReachabilityHandler;
import com.hazelcast.map.record.Record;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class ReachabilityHandlerChain {
    private static final Comparator<ReachabilityHandler> NICE_VALUE_COMPARATOR = new Comparator<ReachabilityHandler>(){

        @Override
        public int compare(ReachabilityHandler o1, ReachabilityHandler o2) {
            short i2;
            short i1 = o1.niceNumber();
            return i1 < (i2 = o2.niceNumber()) ? -1 : (i1 == i2 ? 0 : 1);
        }
    };
    private ReachabilityHandler<Record> firstHandler;
    private ReachabilityHandler<Record> successorHandler;

    public ReachabilityHandlerChain(ReachabilityHandler<Record> ... handlers) {
        for (ReachabilityHandler<Record> evictionHandler : handlers) {
            this.addHandler(evictionHandler);
        }
    }

    public Record isReachable(Record record, long criteria, long now) {
        return this.firstHandler.process(record, criteria, now);
    }

    public void addHandler(ReachabilityHandler<Record> handler) {
        this.addHandlerInternal(handler);
        List<ReachabilityHandler> sortedHandlers = this.sortHandlers();
        this.resetHandlerChain(sortedHandlers);
        for (ReachabilityHandler sortedHandler : sortedHandlers) {
            this.addHandlerInternal(sortedHandler);
        }
    }

    private void addHandlerInternal(ReachabilityHandler<Record> handler) {
        if (this.firstHandler == null) {
            this.firstHandler = handler;
        } else {
            this.successorHandler.setSuccessorHandler(handler);
        }
        this.successorHandler = handler;
    }

    private List<ReachabilityHandler> sortHandlers() {
        ArrayList<ReachabilityHandler> sortedList = new ArrayList<ReachabilityHandler>();
        ReachabilityHandler tempHandler = this.firstHandler;
        sortedList.add(tempHandler);
        while (tempHandler.getSuccessorHandler() != null) {
            tempHandler = tempHandler.getSuccessorHandler();
            sortedList.add(tempHandler);
        }
        Collections.sort(sortedList, NICE_VALUE_COMPARATOR);
        return sortedList;
    }

    private void resetHandlerChain(List<ReachabilityHandler> sortedHandlers) {
        this.firstHandler = null;
        this.successorHandler = null;
        for (ReachabilityHandler sortedHandler : sortedHandlers) {
            sortedHandler.resetHandler();
        }
    }
}

