/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.eviction;

import com.hazelcast.map.eviction.AbstractReachabilityHandler;
import com.hazelcast.map.record.Record;

class IdleReachabilityHandler
extends AbstractReachabilityHandler {
    private final long idleTime;

    public IdleReachabilityHandler(long idleTime) {
        assert (idleTime > 0L) : String.format("Not valid idleTime %d", idleTime);
        this.idleTime = idleTime;
    }

    @Override
    public Record handle(Record record, long criteria, long time) {
        if (record == null) {
            return null;
        }
        long lastAccessTime = record.getLastAccessTime();
        assert (lastAccessTime > 0L);
        assert (time > 0L);
        assert (time >= lastAccessTime);
        boolean result = time - lastAccessTime >= this.idleTime;
        return result ? null : record;
    }

    @Override
    public short niceNumber() {
        return 1;
    }
}

