/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.client;

import com.hazelcast.client.AllPartitionsClientRequest;
import com.hazelcast.client.RetryableRequest;
import com.hazelcast.client.SecureRequest;
import com.hazelcast.map.MapKeySet;
import com.hazelcast.map.MapPortableHook;
import com.hazelcast.map.MapService;
import com.hazelcast.map.operation.MapKeySetOperationFactory;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.Portable;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import com.hazelcast.security.permission.MapPermission;
import com.hazelcast.spi.OperationFactory;
import java.io.IOException;
import java.security.Permission;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class MapKeySetRequest
extends AllPartitionsClientRequest
implements Portable,
RetryableRequest,
SecureRequest {
    private String name;

    public MapKeySetRequest() {
    }

    public MapKeySetRequest(String name) {
        this.name = name;
    }

    @Override
    protected OperationFactory createOperationFactory() {
        return new MapKeySetOperationFactory(this.name);
    }

    @Override
    protected Object reduce(Map<Integer, Object> map) {
        HashSet<Data> res = new HashSet<Data>();
        MapService service = (MapService)this.getService();
        for (Object o : map.values()) {
            Set<Data> keys = ((MapKeySet)service.toObject(o)).getKeySet();
            res.addAll(keys);
        }
        return new MapKeySet(res);
    }

    @Override
    public String getServiceName() {
        return "hz:impl:mapService";
    }

    @Override
    public int getFactoryId() {
        return MapPortableHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 29;
    }

    @Override
    public void write(PortableWriter writer) throws IOException {
        writer.writeUTF("n", this.name);
    }

    @Override
    public void read(PortableReader reader) throws IOException {
        this.name = reader.readUTF("n");
    }

    @Override
    public Permission getRequiredPermission() {
        return new MapPermission(this.name, "read");
    }

    @Override
    public String getMethodName() {
        return "keySet";
    }
}

