/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map;

import com.hazelcast.concurrent.lock.LockService;
import com.hazelcast.concurrent.lock.LockStore;
import com.hazelcast.config.InMemoryFormat;
import com.hazelcast.config.MapConfig;
import com.hazelcast.core.EntryView;
import com.hazelcast.logging.ILogger;
import com.hazelcast.map.EntryViews;
import com.hazelcast.map.MapContainer;
import com.hazelcast.map.MapEntrySet;
import com.hazelcast.map.MapService;
import com.hazelcast.map.MapStoreWrapper;
import com.hazelcast.map.RecordStore;
import com.hazelcast.map.SizeEstimator;
import com.hazelcast.map.SizeEstimators;
import com.hazelcast.map.eviction.EvictionHelper;
import com.hazelcast.map.merge.MapMergePolicy;
import com.hazelcast.map.operation.PutAllOperation;
import com.hazelcast.map.operation.PutFromLoadAllOperation;
import com.hazelcast.map.record.Record;
import com.hazelcast.map.record.RecordFactory;
import com.hazelcast.map.writebehind.DelayedEntry;
import com.hazelcast.map.writebehind.WriteBehindQueue;
import com.hazelcast.map.writebehind.WriteBehindQueues;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.SerializationService;
import com.hazelcast.query.impl.IndexService;
import com.hazelcast.query.impl.QueryEntry;
import com.hazelcast.spi.DefaultObjectNamespace;
import com.hazelcast.spi.ExecutionService;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.OperationAccessor;
import com.hazelcast.spi.OperationService;
import com.hazelcast.spi.ResponseHandler;
import com.hazelcast.spi.exception.RetryableHazelcastException;
import com.hazelcast.util.Clock;
import com.hazelcast.util.ExceptionUtil;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public class DefaultRecordStore
implements RecordStore {
    private static final long DEFAULT_TTL = -1L;
    private static final int POST_READ_CHECK_POINT = 63;
    private final String name;
    private final int partitionId;
    private final ConcurrentMap<Data, Record> records = new ConcurrentHashMap<Data, Record>(1000);
    private final MapContainer mapContainer;
    private final MapService mapService;
    private final RecordFactory recordFactory;
    private final ILogger logger;
    private final SizeEstimator sizeEstimator;
    private final AtomicBoolean loaded = new AtomicBoolean(false);
    private final WriteBehindQueue<DelayedEntry> writeBehindQueue;
    private final LockStore lockStore;
    private long lastEvictionTime;
    private volatile boolean expirable;
    private Iterator<Record> expirationIterator;
    private Iterator<DelayedEntry> evictionStagingAreaIterator;
    private int readCountBeforeCleanUp;
    private final Set<Data> writeBehindWaitingDeletions;
    private final Map<Data, DelayedEntry> evictionStagingArea;
    private long lruAccessSequenceNumber;

    public DefaultRecordStore(String name, MapService mapService, int partitionId) {
        this.name = name;
        this.partitionId = partitionId;
        this.mapService = mapService;
        this.mapContainer = mapService.getMapContainer(name);
        this.logger = mapService.getNodeEngine().getLogger(this.getName());
        this.recordFactory = this.mapContainer.getRecordFactory();
        this.lockStore = this.createLockStore();
        this.sizeEstimator = SizeEstimators.createMapSizeEstimator();
        this.writeBehindQueue = this.createWriteBehindQueue();
        this.writeBehindWaitingDeletions = this.createWriteBehindWaitingDeletionsSet();
        this.expirable = this.isRecordStoreExpirable();
        this.evictionStagingArea = this.createEvictionStagingArea();
        this.loadFromMapStore();
    }

    @Override
    public boolean isLoaded() {
        return this.loaded.get();
    }

    @Override
    public void setLoaded(boolean isLoaded) {
        this.loaded.set(isLoaded);
    }

    @Override
    public void checkIfLoaded() {
        if (this.mapContainer.getStore() != null && !this.loaded.get()) {
            throw ExceptionUtil.rethrow(new RetryableHazelcastException("Map is not ready!!!"));
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void flush() {
        this.checkIfLoaded();
        Collection<Data> processedKeys = this.mapContainer.getWriteBehindManager().flush(this.writeBehindQueue);
        for (Data pkey : processedKeys) {
            Record record = (Record)this.records.get(pkey);
            if (record == null) continue;
            record.onStore();
        }
    }

    @Override
    public MapContainer getMapContainer() {
        return this.mapContainer;
    }

    @Override
    public Record getRecord(Data key) {
        return (Record)this.records.get(key);
    }

    @Override
    public void putRecord(Data key, Record record) {
        Record existingRecord = this.records.put(key, record);
        this.updateSizeEstimator(-this.calculateRecordSize(existingRecord));
        this.updateSizeEstimator(this.calculateRecordSize(record));
        this.removeFromWriteBehindWaitingDeletions(key);
    }

    @Override
    public Record putBackup(Data key, Object value) {
        return this.putBackup(key, value, -1L);
    }

    @Override
    public Record putBackup(Data key, Object value, long ttl) {
        long now = this.getNow();
        this.earlyWriteCleanup(now);
        this.markRecordStoreExpirable(ttl);
        Record record = (Record)this.records.get(key);
        if (record == null) {
            record = this.mapService.createRecord(this.name, key, value, ttl, now);
            this.records.put(key, record);
            this.updateSizeEstimator(this.calculateRecordSize(record));
        } else {
            this.updateSizeEstimator(-this.calculateRecordSize(record));
            this.setRecordValue(record, value, now);
            this.updateSizeEstimator(this.calculateRecordSize(record));
        }
        this.removeFromWriteBehindWaitingDeletions(key);
        this.addToDelayedStore(key, record.getValue(), now);
        return record;
    }

    @Override
    public void deleteRecord(Data key) {
        Record record = (Record)this.records.remove(key);
        if (record != null) {
            record.invalidate();
        }
    }

    @Override
    public Map<Data, Record> getReadonlyRecordMap() {
        return Collections.unmodifiableMap(this.records);
    }

    @Override
    public Map<Data, Record> getReadonlyRecordMapByWaitingMapStoreLoad() {
        this.checkIfLoaded();
        return this.getReadonlyRecordMap();
    }

    @Override
    public void clearPartition() {
        IndexService indexService;
        NodeEngine nodeEngine = this.mapService.getNodeEngine();
        LockService lockService = (LockService)nodeEngine.getSharedService("hz:impl:lockService");
        if (lockService != null) {
            DefaultObjectNamespace namespace = new DefaultObjectNamespace("hz:impl:mapService", this.name);
            lockService.clearLockStore(this.partitionId, namespace);
        }
        if ((indexService = this.mapContainer.getIndexService()).hasIndex()) {
            for (Data key : this.records.keySet()) {
                indexService.removeEntryIndex(key);
            }
        }
        this.clearRecordsMap(Collections.<Data, Record>emptyMap());
        this.resetSizeEstimator();
        this.resetAccessSequenceNumber();
        this.writeBehindQueue.clear();
        this.writeBehindWaitingDeletions.clear();
        this.evictionStagingArea.clear();
    }

    private void clearRecordsMap(Map<Data, Record> excludeRecords) {
        InMemoryFormat inMemoryFormat = this.recordFactory.getStorageFormat();
        switch (inMemoryFormat) {
            case BINARY: 
            case OBJECT: {
                this.records.clear();
                if (excludeRecords != null && !excludeRecords.isEmpty()) {
                    this.records.putAll(excludeRecords);
                }
                return;
            }
            case OFFHEAP: {
                Iterator iter = this.records.values().iterator();
                while (iter.hasNext()) {
                    Record record = (Record)iter.next();
                    if (excludeRecords != null && excludeRecords.containsKey(record.getKey())) continue;
                    record.invalidate();
                    iter.remove();
                }
                return;
            }
        }
        throw new IllegalArgumentException("Unknown storage format: " + (Object)((Object)inMemoryFormat));
    }

    @Override
    public int size() {
        return this.records.size();
    }

    @Override
    public boolean isEmpty() {
        this.checkIfLoaded();
        return this.records.isEmpty();
    }

    @Override
    public WriteBehindQueue<DelayedEntry> getWriteBehindQueue() {
        return this.writeBehindQueue;
    }

    @Override
    public void evictExpiredEntries(int percentage, boolean ownerPartition) {
        long now = this.getNow();
        int size = this.size();
        int maxIterationCount = this.getMaxIterationCount(size, percentage);
        int maxRetry = 3;
        int loop = 0;
        int evicteds = 0;
        while ((evicteds += this.evictExpiredEntries0(maxIterationCount, now, ownerPartition)) < maxIterationCount && ++loop <= 3) {
        }
    }

    private int getMaxIterationCount(int size, int percentage) {
        int defaultMaxIterationCount = 100;
        float oneHundred = 100.0f;
        float maxIterationCount = (float)size * ((float)percentage / 100.0f);
        if (maxIterationCount <= 100.0f) {
            return 100;
        }
        return Math.round(maxIterationCount);
    }

    private int evictExpiredEntries0(int maxIterationCount, long now, boolean ownerPartition) {
        int evictedCount = 0;
        int checkedEntryCount = 0;
        this.initExpirationIterator();
        while (this.expirationIterator.hasNext() && checkedEntryCount < maxIterationCount) {
            ++checkedEntryCount;
            Record record = this.expirationIterator.next();
            Data key = record.getKey();
            if (this.isLocked(key) || this.isReachable(record, now)) continue;
            Object value = record.getValue();
            this.evict0(key);
            ++evictedCount;
            this.initExpirationIterator();
            if (ownerPartition) {
                this.doPostEvictionOperations(key, value);
            }
            if (this.expirationIterator.hasNext()) continue;
            break;
        }
        return evictedCount;
    }

    private void initExpirationIterator() {
        if (this.expirationIterator == null || !this.expirationIterator.hasNext()) {
            this.expirationIterator = this.records.values().iterator();
        }
    }

    @Override
    public boolean containsValue(Object value) {
        this.checkIfLoaded();
        long now = this.getNow();
        for (Record record : this.records.values()) {
            if (this.nullIfExpired(record) == null || !this.mapService.compare(this.name, value, record.getValue())) continue;
            return true;
        }
        this.postReadCleanUp(now);
        return false;
    }

    @Override
    public boolean lock(Data key, String caller, long threadId, long ttl) {
        this.checkIfLoaded();
        return this.lockStore != null && this.lockStore.lock(key, caller, threadId, ttl);
    }

    @Override
    public boolean txnLock(Data key, String caller, long threadId, long ttl) {
        this.checkIfLoaded();
        return this.lockStore != null && this.lockStore.txnLock(key, caller, threadId, ttl);
    }

    @Override
    public boolean extendLock(Data key, String caller, long threadId, long ttl) {
        this.checkIfLoaded();
        return this.lockStore != null && this.lockStore.extendLeaseTime(key, caller, threadId, ttl);
    }

    @Override
    public boolean unlock(Data key, String caller, long threadId) {
        this.checkIfLoaded();
        return this.lockStore != null && this.lockStore.unlock(key, caller, threadId);
    }

    @Override
    public boolean forceUnlock(Data dataKey) {
        return this.lockStore != null && this.lockStore.forceUnlock(dataKey);
    }

    @Override
    public long getHeapCost() {
        return this.sizeEstimator.getSize();
    }

    @Override
    public boolean isLocked(Data dataKey) {
        return this.lockStore != null && this.lockStore.isLocked(dataKey);
    }

    @Override
    public boolean canAcquireLock(Data key, String caller, long threadId) {
        return this.lockStore == null || this.lockStore.canAcquireLock(key, caller, threadId);
    }

    @Override
    public String getLockOwnerInfo(Data key) {
        return this.lockStore != null ? this.lockStore.getOwnerInfo(key) : null;
    }

    @Override
    public Set<Map.Entry<Data, Data>> entrySetData() {
        this.checkIfLoaded();
        HashMap<Data, Data> temp = new HashMap<Data, Data>(this.records.size());
        for (Data key : this.records.keySet()) {
            temp.put(key, this.mapService.toData(((Record)this.records.get(key)).getValue()));
        }
        return temp.entrySet();
    }

    @Override
    public Map.Entry<Data, Object> getMapEntry(Data dataKey) {
        this.checkIfLoaded();
        Record record = (Record)this.records.get(dataKey);
        if (record == null) {
            record = this.getRecordInternal(dataKey, true);
        } else {
            this.accessRecord(record);
        }
        Object data = record != null ? (Object)record.getValue() : null;
        return new AbstractMap.SimpleImmutableEntry<Data, Object>(dataKey, data);
    }

    @Override
    public Map.Entry<Data, Object> getMapEntryForBackup(Data dataKey) {
        this.checkIfLoaded();
        Record record = (Record)this.records.get(dataKey);
        if (record == null) {
            record = this.getRecordInternal(dataKey, false);
        } else {
            this.accessRecord(record);
        }
        Object data = record != null ? (Object)record.getValue() : null;
        return new AbstractMap.SimpleImmutableEntry<Data, Object>(dataKey, data);
    }

    private Record getRecordInternal(Data key, boolean enableIndex) {
        Object value;
        Record record = null;
        if (this.mapContainer.getStore() != null && (value = this.loadFromStoreOrStagingArea(key)) != null) {
            record = this.mapService.createRecord(this.name, key, value, -1L, this.getNow());
            this.records.put(key, record);
            if (enableIndex) {
                this.saveIndex(record);
            }
            this.updateSizeEstimator(this.calculateRecordSize(record));
        }
        return record;
    }

    @Override
    public Set<Data> keySet() {
        this.checkIfLoaded();
        HashSet<Data> keySet = new HashSet<Data>(this.records.size());
        for (Data data : this.records.keySet()) {
            keySet.add(data);
        }
        return keySet;
    }

    @Override
    public Collection<Data> valuesData() {
        this.checkIfLoaded();
        ArrayList<Data> values = new ArrayList<Data>(this.records.size());
        for (Record record : this.records.values()) {
            values.add(this.mapService.toData(record.getValue()));
        }
        return values;
    }

    @Override
    public int clear() {
        this.checkIfLoaded();
        this.resetSizeEstimator();
        Set<Data> lockedKeys = this.lockStore != null ? this.lockStore.getLockedKeys() : Collections.emptySet();
        HashMap<Data, Record> lockedRecords = new HashMap<Data, Record>(lockedKeys.size());
        for (Data key : lockedKeys) {
            Record record = (Record)this.records.get(key);
            if (record == null) continue;
            lockedRecords.put(key, record);
            this.updateSizeEstimator(this.calculateRecordSize(record));
        }
        Set<Data> keysToDelete = this.records.keySet();
        keysToDelete.removeAll(lockedRecords.keySet());
        MapStoreWrapper store = this.mapContainer.getStore();
        if (store != null) {
            ArrayList<Object> keysObject = new ArrayList<Object>(keysToDelete.size());
            for (Data key : keysToDelete) {
                keysObject.add(this.mapService.toObject(key));
            }
            store.deleteAll(keysObject);
        }
        int numOfClearedEntries = keysToDelete.size();
        this.removeIndex(keysToDelete);
        this.clearRecordsMap(lockedRecords);
        this.resetAccessSequenceNumber();
        this.writeBehindQueue.clear();
        return numOfClearedEntries;
    }

    @Override
    public void reset() {
        this.checkIfLoaded();
        this.clearRecordsMap(Collections.<Data, Record>emptyMap());
        this.resetSizeEstimator();
        this.resetAccessSequenceNumber();
        this.writeBehindQueue.clear();
        this.writeBehindWaitingDeletions.clear();
        this.evictionStagingArea.clear();
    }

    private void resetAccessSequenceNumber() {
        this.lruAccessSequenceNumber = 0L;
    }

    @Override
    public Object evict(Data key) {
        this.checkIfLoaded();
        return this.evict0(key);
    }

    private Object evict0(Data key) {
        Record record = (Record)this.records.get(key);
        Object value = null;
        if (record != null) {
            value = record.getValue();
            long lastUpdateTime = record.getLastUpdateTime();
            this.putEvictionStagingArea(key, value, lastUpdateTime);
            this.mapService.interceptRemove(this.name, value);
            this.updateSizeEstimator(-this.calculateRecordSize(record));
            this.deleteRecord(key);
            this.removeIndex(key);
        }
        this.removeFromWriteBehindWaitingDeletions(key);
        return value;
    }

    @Override
    public int evictAll() {
        this.checkIfLoaded();
        int size = this.size();
        Set<Data> keysToPreserve = this.evictAll0();
        this.removeIndexByPreserving(keysToPreserve);
        return size - keysToPreserve.size();
    }

    @Override
    public void evictAllBackup() {
        this.evictAll0();
    }

    private Set<Data> evictAll0() {
        this.resetSizeEstimator();
        this.resetAccessSequenceNumber();
        Set<Data> keysToPreserve = Collections.emptySet();
        Map<Data, Record> recordsToPreserve = this.getLockedRecords();
        if (!recordsToPreserve.isEmpty()) {
            keysToPreserve = recordsToPreserve.keySet();
            this.updateSizeEstimator(this.calculateRecordSize(recordsToPreserve.values()));
        }
        this.clearRecordsMap(recordsToPreserve);
        return keysToPreserve;
    }

    private void removeIndexByPreserving(Set<Data> keysToPreserve) {
        Set<Data> currentKeySet = this.records.keySet();
        currentKeySet.removeAll(keysToPreserve);
        this.removeIndex(currentKeySet);
    }

    private Map<Data, Record> getLockedRecords() {
        if (this.lockStore == null) {
            return Collections.emptyMap();
        }
        Set<Data> lockedKeys = this.lockStore.getLockedKeys();
        if (lockedKeys.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<Data, Record> lockedRecords = new HashMap<Data, Record>(lockedKeys.size());
        for (Data key : lockedKeys) {
            Record record = (Record)this.records.get(key);
            if (record == null) continue;
            lockedRecords.put(key, record);
        }
        return lockedRecords;
    }

    @Override
    public void removeBackup(Data key) {
        long now = this.getNow();
        this.earlyWriteCleanup(now);
        Record record = (Record)this.records.get(key);
        if (record == null) {
            return;
        }
        this.updateSizeEstimator(-this.calculateRecordSize(record));
        this.deleteRecord(key);
        this.addToDelayedStore(key, null, now);
    }

    @Override
    public boolean remove(Data key, Object testValue) {
        this.checkIfLoaded();
        long now = this.getNow();
        this.earlyWriteCleanup(now);
        Record record = (Record)this.records.get(key);
        Object oldValue = null;
        boolean removed = false;
        if (record == null) {
            if (this.mapContainer.getStore() != null) {
                oldValue = this.loadFromStoreOrStagingArea(key);
            }
            if (oldValue == null) {
                return false;
            }
        } else {
            oldValue = record.getValue();
        }
        if (this.mapService.compare(this.name, testValue, oldValue)) {
            this.mapService.interceptRemove(this.name, oldValue);
            this.removeIndex(key);
            this.mapStoreDelete(record, key, now);
            this.updateSizeEstimator(-this.calculateRecordSize(record));
            this.deleteRecord(key);
            removed = true;
        }
        return removed;
    }

    @Override
    public Object remove(Data key) {
        this.checkIfLoaded();
        long now = this.getNow();
        this.earlyWriteCleanup(now);
        Record record = (Record)this.records.get(key);
        Object oldValue = null;
        if (record == null) {
            if (this.mapContainer.getStore() != null && (oldValue = this.loadFromStoreOrStagingArea(key)) != null) {
                this.removeIndex(key);
                this.mapStoreDelete(null, key, now);
            }
        } else {
            oldValue = record.getValue();
            if ((oldValue = this.mapService.interceptRemove(this.name, oldValue)) != null) {
                this.removeIndex(key);
                this.mapStoreDelete(record, key, now);
            }
            this.updateSizeEstimator(-this.calculateRecordSize(record));
            this.deleteRecord(key);
        }
        return oldValue;
    }

    @Override
    public Object get(Data key) {
        this.checkIfLoaded();
        long now = this.getNow();
        Record record = (Record)this.records.get(key);
        record = this.nullIfExpired(record);
        Object value = null;
        if (record == null) {
            if (this.mapContainer.getStore() != null && (value = this.loadFromStoreOrStagingArea(key)) != null) {
                record = this.mapService.createRecord(this.name, key, value, -1L, now);
                this.records.put(key, record);
                this.saveIndex(record);
                this.updateSizeEstimator(this.calculateRecordSize(record));
            }
        } else {
            this.accessRecord(record, now);
            value = record.getValue();
        }
        value = this.mapService.interceptGet(this.name, value);
        this.postReadCleanUp(now);
        return value;
    }

    private Object loadFromStoreOrStagingArea(Data key) {
        if (this.hasWaitingWriteBehindDeleteOperation(key)) {
            return null;
        }
        Object fromStagingArea = this.getFromEvictionStagingArea(key);
        return fromStagingArea == null ? this.mapContainer.getStore().load(this.mapService.toObject(key)) : fromStagingArea;
    }

    @Override
    public MapEntrySet getAll(Set<Data> keySet) {
        this.checkIfLoaded();
        long now = this.getNow();
        MapEntrySet mapEntrySet = new MapEntrySet();
        Map<Object, Data> keyMapForLoader = Collections.emptyMap();
        if (this.mapContainer.getStore() != null) {
            keyMapForLoader = new HashMap();
        }
        for (Data dataKey : keySet) {
            Record record = (Record)this.records.get(dataKey);
            if (record == null) {
                if (this.mapContainer.getStore() == null) continue;
                keyMapForLoader.put(this.mapService.toObject(dataKey), dataKey);
                continue;
            }
            this.accessRecord(record);
            Object value = record.getValue();
            if ((value = this.mapService.interceptGet(this.name, value)) == null) continue;
            mapEntrySet.add(new AbstractMap.SimpleImmutableEntry<Data, Data>(dataKey, this.mapService.toData(value)));
        }
        if (this.mapContainer.getStore() == null || keyMapForLoader.size() == 0) {
            return mapEntrySet;
        }
        Map<Object, Object> fromEvictionStagingArea = this.getFromEvictionStagingArea(keySet);
        for (Object o : fromEvictionStagingArea.keySet()) {
            keyMapForLoader.remove(o);
        }
        Map loadedKeys = this.mapContainer.getStore().loadAll((Collection)keyMapForLoader.keySet());
        for (Map.Entry entry : loadedKeys.entrySet()) {
            Object objectKey = entry.getKey();
            Object value = entry.getValue();
            Data dataKey = (Data)keyMapForLoader.get(objectKey);
            if (this.hasWaitingWriteBehindDeleteOperation(dataKey)) continue;
            if (value != null) {
                Record record = this.mapService.createRecord(this.name, dataKey, value, -1L, now);
                this.records.put(dataKey, record);
                this.saveIndex(record);
                this.updateSizeEstimator(this.calculateRecordSize(record));
            }
            if ((value = this.mapService.interceptGet(this.name, value)) == null) continue;
            mapEntrySet.add(new AbstractMap.SimpleImmutableEntry<Data, Data>(dataKey, this.mapService.toData(value)));
        }
        this.postReadCleanUp(now);
        return mapEntrySet;
    }

    @Override
    public boolean containsKey(Data key) {
        boolean contains;
        Object value;
        this.checkIfLoaded();
        long now = this.getNow();
        Record record = (Record)this.records.get(key);
        record = this.nullIfExpired(record);
        if (record == null && this.mapContainer.getStore() != null && (value = this.loadFromStoreOrStagingArea(key)) != null) {
            record = this.mapService.createRecord(this.name, key, value, -1L, now);
            this.records.put(key, record);
            this.updateSizeEstimator(this.calculateRecordSize(record));
        }
        boolean bl = contains = record != null;
        if (contains) {
            this.accessRecord(record, now);
        }
        this.postReadCleanUp(now);
        return contains;
    }

    @Override
    public void put(Map.Entry<Data, Object> entry) {
        this.checkIfLoaded();
        long now = this.getNow();
        this.earlyWriteCleanup(now);
        Data key = entry.getKey();
        Object value = entry.getValue();
        Record record = (Record)this.records.get(key);
        if (record == null) {
            value = this.mapService.interceptPut(this.name, null, value);
            value = this.mapStoreWrite(key, value, null, now);
            record = this.mapService.createRecord(this.name, key, value, -1L, now);
            this.records.put(key, record);
            this.updateSizeEstimator(this.calculateRecordSize(record));
            this.saveIndex(record);
        } else {
            Object oldValue = record.getValue();
            value = this.mapService.interceptPut(this.name, oldValue, value);
            value = this.mapStoreWrite(key, value, record, now);
            this.updateSizeEstimator(-this.calculateRecordSize(record));
            this.setRecordValue(record, value, now);
            this.updateSizeEstimator(this.calculateRecordSize(record));
            this.saveIndex(record);
        }
        this.removeFromWriteBehindWaitingDeletions(key);
    }

    @Override
    public Object put(Data key, Object value, long ttl) {
        this.checkIfLoaded();
        long now = this.getNow();
        this.earlyWriteCleanup(now);
        this.markRecordStoreExpirable(ttl);
        Record record = (Record)this.records.get(key);
        Object oldValue = null;
        if (record == null) {
            if (this.mapContainer.getStore() != null) {
                oldValue = this.loadFromStoreOrStagingArea(key);
            }
            value = this.mapService.interceptPut(this.name, null, value);
            value = this.mapStoreWrite(key, value, null, now);
            record = this.mapService.createRecord(this.name, key, value, ttl, now);
            this.records.put(key, record);
            this.updateSizeEstimator(this.calculateRecordSize(record));
            this.saveIndex(record);
        } else {
            oldValue = record.getValue();
            value = this.mapService.interceptPut(this.name, oldValue, value);
            value = this.mapStoreWrite(key, value, record, now);
            this.updateSizeEstimator(-this.calculateRecordSize(record));
            this.setRecordValue(record, value, now);
            this.updateSizeEstimator(this.calculateRecordSize(record));
            this.updateTtl(record, ttl);
            this.saveIndex(record);
        }
        this.removeFromWriteBehindWaitingDeletions(key);
        return oldValue;
    }

    @Override
    public boolean set(Data key, Object value, long ttl) {
        this.checkIfLoaded();
        long now = this.getNow();
        this.earlyWriteCleanup(now);
        this.markRecordStoreExpirable(ttl);
        Record record = (Record)this.records.get(key);
        boolean newRecord = false;
        if (record == null) {
            value = this.mapService.interceptPut(this.name, null, value);
            value = this.mapStoreWrite(key, value, null, now);
            record = this.mapService.createRecord(this.name, key, value, ttl, now);
            this.records.put(key, record);
            this.updateSizeEstimator(this.calculateRecordSize(record));
            newRecord = true;
        } else {
            value = this.mapService.interceptPut(this.name, record.getValue(), value);
            value = this.mapStoreWrite(key, value, record, now);
            this.updateSizeEstimator(-this.calculateRecordSize(record));
            this.setRecordValue(record, value, now);
            this.updateSizeEstimator(this.calculateRecordSize(record));
            this.updateTtl(record, ttl);
        }
        this.saveIndex(record);
        this.removeFromWriteBehindWaitingDeletions(key);
        return newRecord;
    }

    @Override
    public boolean merge(Data key, EntryView mergingEntry, MapMergePolicy mergePolicy) {
        Object newValue;
        this.checkIfLoaded();
        long now = this.getNow();
        this.earlyWriteCleanup(now);
        Record record = (Record)this.records.get(key);
        if (record == null) {
            Object notExistingKey = this.mapService.toObject(key);
            EntryView nullEntryView = EntryViews.createNullEntryView(notExistingKey);
            newValue = mergePolicy.merge(this.name, mergingEntry, nullEntryView);
            if (newValue == null) {
                return false;
            }
            newValue = this.mapStoreWrite(key, newValue, null, now);
            record = this.mapService.createRecord(this.name, key, newValue, -1L, now);
            this.records.put(key, record);
            this.updateSizeEstimator(this.calculateRecordSize(record));
        } else {
            Object oldValue = record.getValue();
            EntryView<Object, Object> existingEntry = EntryViews.createSimpleEntryView(this.mapService.toObject(record.getKey()), this.mapService.toObject(record.getValue()), record);
            newValue = mergePolicy.merge(this.name, mergingEntry, existingEntry);
            if (newValue == null) {
                this.removeIndex(key);
                this.mapStoreDelete(record, key, now);
                this.updateSizeEstimator(-this.calculateRecordSize(record));
                this.deleteRecord(key);
                return true;
            }
            if (this.mapService.compare(this.name, newValue, oldValue)) {
                return true;
            }
            newValue = this.mapStoreWrite(key, newValue, record, now);
            this.updateSizeEstimator(-this.calculateRecordSize(record));
            this.recordFactory.setValue(record, newValue);
            this.updateSizeEstimator(this.calculateRecordSize(record));
        }
        this.saveIndex(record);
        return newValue != null;
    }

    @Override
    public Object replace(Data dataKey, Object value) {
        this.checkIfLoaded();
        long now = this.getNow();
        this.earlyWriteCleanup(now);
        Record record = (Record)this.records.get(dataKey);
        if (record == null || record.getValue() == null) {
            return null;
        }
        Object oldValue = record.getValue();
        value = this.mapService.interceptPut(this.name, oldValue, value);
        value = this.mapStoreWrite(dataKey, value, record, now);
        this.updateSizeEstimator(-this.calculateRecordSize(record));
        this.setRecordValue(record, value, now);
        this.updateSizeEstimator(this.calculateRecordSize(record));
        this.saveIndex(record);
        return oldValue;
    }

    @Override
    public boolean replace(Data dataKey, Object testValue, Object newValue) {
        this.checkIfLoaded();
        long now = this.getNow();
        this.earlyWriteCleanup(now);
        Record record = (Record)this.records.get(dataKey);
        if (record == null) {
            return false;
        }
        if (!this.mapService.compare(this.name, record.getValue(), testValue)) {
            return false;
        }
        newValue = this.mapService.interceptPut(this.name, record.getValue(), newValue);
        newValue = this.mapStoreWrite(dataKey, newValue, record, now);
        this.updateSizeEstimator(-this.calculateRecordSize(record));
        this.setRecordValue(record, newValue, now);
        this.updateSizeEstimator(this.calculateRecordSize(record));
        this.saveIndex(record);
        return true;
    }

    @Override
    public void putTransient(Data key, Object value, long ttl) {
        this.checkIfLoaded();
        long now = this.getNow();
        this.earlyWriteCleanup(now);
        this.markRecordStoreExpirable(ttl);
        Record record = (Record)this.records.get(key);
        if (record == null) {
            value = this.mapService.interceptPut(this.name, null, value);
            record = this.mapService.createRecord(this.name, key, value, ttl, now);
            this.records.put(key, record);
            this.updateSizeEstimator(this.calculateRecordSize(record));
        } else {
            value = this.mapService.interceptPut(this.name, record.getValue(), value);
            this.updateSizeEstimator(-this.calculateRecordSize(record));
            this.setRecordValue(record, value, now);
            this.updateSizeEstimator(this.calculateRecordSize(record));
            this.updateTtl(record, ttl);
        }
        this.saveIndex(record);
        this.removeFromWriteBehindWaitingDeletions(key);
    }

    @Override
    public Object putFromLoad(Data key, Object value) {
        return this.putFromLoad(key, value, -1L);
    }

    @Override
    public Object putFromLoad(Data key, Object value, long ttl) {
        long now = this.getNow();
        this.earlyWriteCleanup(now);
        this.markRecordStoreExpirable(ttl);
        Record record = (Record)this.records.get(key);
        Object oldValue = null;
        if (record == null) {
            value = this.mapService.interceptPut(this.name, null, value);
            record = this.mapService.createRecord(this.name, key, value, ttl, now);
            this.records.put(key, record);
            this.updateSizeEstimator(this.calculateRecordSize(record));
        } else {
            oldValue = record.getValue();
            value = this.mapService.interceptPut(this.name, record.getValue(), value);
            this.updateSizeEstimator(-this.calculateRecordSize(record));
            this.setRecordValue(record, value, now);
            this.updateSizeEstimator(this.calculateRecordSize(record));
            this.updateTtl(record, ttl);
        }
        this.saveIndex(record);
        this.removeFromWriteBehindWaitingDeletions(key);
        return oldValue;
    }

    @Override
    public boolean tryPut(Data key, Object value, long ttl) {
        this.checkIfLoaded();
        long now = this.getNow();
        this.earlyWriteCleanup(now);
        this.markRecordStoreExpirable(ttl);
        Record record = (Record)this.records.get(key);
        if (record == null) {
            value = this.mapService.interceptPut(this.name, null, value);
            value = this.mapStoreWrite(key, value, null, now);
            record = this.mapService.createRecord(this.name, key, value, ttl, now);
            this.records.put(key, record);
            this.updateSizeEstimator(this.calculateRecordSize(record));
        } else {
            value = this.mapService.interceptPut(this.name, record.getValue(), value);
            value = this.mapStoreWrite(key, value, record, now);
            this.updateSizeEstimator(-this.calculateRecordSize(record));
            this.setRecordValue(record, value, now);
            this.updateSizeEstimator(this.calculateRecordSize(record));
            this.updateTtl(record, ttl);
        }
        this.saveIndex(record);
        this.removeFromWriteBehindWaitingDeletions(key);
        return true;
    }

    @Override
    public Object putIfAbsent(Data key, Object value, long ttl) {
        this.checkIfLoaded();
        long now = this.getNow();
        this.earlyWriteCleanup(now);
        this.markRecordStoreExpirable(ttl);
        Record record = (Record)this.records.get(key);
        Object oldValue = null;
        if (record == null) {
            if (this.mapContainer.getStore() != null && (oldValue = this.loadFromStoreOrStagingArea(key)) != null) {
                record = this.mapService.createRecord(this.name, key, oldValue, -1L, now);
                this.records.put(key, record);
                this.updateSizeEstimator(this.calculateRecordSize(record));
            }
        } else {
            this.accessRecord(record, now);
            oldValue = record.getValue();
        }
        if (oldValue == null) {
            value = this.mapService.interceptPut(this.name, null, value);
            value = this.mapStoreWrite(key, value, record, now);
            record = this.mapService.createRecord(this.name, key, value, ttl, now);
            this.records.put(key, record);
            this.updateSizeEstimator(this.calculateRecordSize(record));
            this.updateTtl(record, ttl);
        }
        this.saveIndex(record);
        this.removeFromWriteBehindWaitingDeletions(key);
        return oldValue;
    }

    private void loadFromMapStore() {
        NodeEngine nodeEngine = this.mapService.getNodeEngine();
        AtomicBoolean loadOccurred = this.loaded;
        if (!this.mapContainer.isMapStoreEnabled() || loadOccurred.get()) {
            return;
        }
        Address partitionOwner = nodeEngine.getPartitionService().getPartitionOwner(this.partitionId);
        boolean isOwner = nodeEngine.getThisAddress().equals(partitionOwner);
        if (!isOwner) {
            loadOccurred.set(true);
            return;
        }
        Map<Data, Object> loadedKeys = this.mapContainer.getInitialKeys();
        if (loadedKeys == null || loadedKeys.isEmpty()) {
            loadOccurred.set(true);
            return;
        }
        this.doChunkedLoad(loadedKeys, nodeEngine);
    }

    private void doChunkedLoad(Map<Data, Object> loadedKeys, NodeEngine nodeEngine) {
        int mapLoadChunkSize = nodeEngine.getGroupProperties().MAP_LOAD_CHUNK_SIZE.getInteger();
        LinkedList chunks = new LinkedList();
        HashMap<Data, Object> partitionKeys = new HashMap<Data, Object>();
        Iterator<Map.Entry<Data, Object>> iterator = loadedKeys.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Data, Object> entry = iterator.next();
            Data data = entry.getKey();
            if (this.partitionId != nodeEngine.getPartitionService().getPartitionId(data)) continue;
            partitionKeys.put(data, entry.getValue());
            if (partitionKeys.size() >= mapLoadChunkSize) {
                chunks.add(partitionKeys);
                partitionKeys = new HashMap();
            }
            iterator.remove();
        }
        if (!partitionKeys.isEmpty()) {
            chunks.add(partitionKeys);
        }
        if (chunks.isEmpty()) {
            this.loaded.set(true);
            return;
        }
        try {
            Map chunkedKeys;
            AtomicInteger checkIfMapLoaded = new AtomicInteger(chunks.size());
            ExecutionService executionService = nodeEngine.getExecutionService();
            while ((chunkedKeys = (Map)chunks.poll()) != null) {
                executionService.submit("hz:map-load", new MapLoadAllTask(chunkedKeys, checkIfMapLoaded));
            }
        }
        catch (Throwable t) {
            throw ExceptionUtil.rethrow(t);
        }
    }

    private void earlyWriteCleanup(long now) {
        this.cleanupEvictionStagingArea(now);
        if (this.mapContainer.isEvictionEnabled()) {
            this.cleanUp(now);
        }
    }

    private void postReadCleanUp(long now) {
        this.cleanupEvictionStagingArea(now);
        if (this.mapContainer.isEvictionEnabled()) {
            ++this.readCountBeforeCleanUp;
            if ((this.readCountBeforeCleanUp & 0x3F) == 0) {
                this.cleanUp(now);
            }
        }
    }

    private void cleanUp(long now) {
        if (this.size() == 0) {
            return;
        }
        if (this.inEvictableTimeWindow(now) && this.isEvictable()) {
            this.removeEvictables();
            this.lastEvictionTime = now;
            this.readCountBeforeCleanUp = 0;
        }
    }

    private void removeEvictables() {
        EvictionHelper.removeEvictableRecords(this, this.mapContainer.getMapConfig(), this.mapService);
    }

    private boolean inEvictableTimeWindow(long now) {
        int evictAfterMs = 1000;
        return now - this.lastEvictionTime > 1000L;
    }

    private boolean isEvictable() {
        return EvictionHelper.checkEvictable(this.mapContainer);
    }

    private Record nullIfExpired(Record record) {
        return this.evictIfNotReachable(record);
    }

    private void addToWriteBehindWaitingDeletions(Data key) {
        if (!this.mapContainer.isWriteBehindMapStoreEnabled()) {
            return;
        }
        this.writeBehindWaitingDeletions.add(key);
    }

    @Override
    public void removeFromWriteBehindWaitingDeletions(Data key) {
        if (!this.mapContainer.isWriteBehindMapStoreEnabled()) {
            return;
        }
        this.writeBehindWaitingDeletions.remove(key);
    }

    private boolean isInWriteBehindWaitingDeletions(Data key) {
        if (!this.mapContainer.isWriteBehindMapStoreEnabled()) {
            return false;
        }
        return this.writeBehindWaitingDeletions.contains(key);
    }

    private void initStagingAreaIterator() {
        if (this.evictionStagingAreaIterator == null || !this.evictionStagingAreaIterator.hasNext()) {
            this.evictionStagingAreaIterator = this.evictionStagingArea.values().iterator();
        }
    }

    private void cleanupEvictionStagingArea(long now) {
        if (!this.mapContainer.isWriteBehindMapStoreEnabled()) {
            return;
        }
        if (this.evictionStagingArea.isEmpty() || !this.inEvictableTimeWindow(now)) {
            return;
        }
        long nextItemsStoreTimeInWriteBehindQueue = this.getNextItemsStoreTimeInWriteBehindQueue();
        int size = this.evictionStagingArea.size();
        int evictionPercentage = 20;
        int maxAllowedIterationCount = this.getMaxIterationCount(size, 20);
        this.initStagingAreaIterator();
        while (this.evictionStagingAreaIterator.hasNext() && maxAllowedIterationCount > 0) {
            --maxAllowedIterationCount;
            DelayedEntry entry = this.evictionStagingAreaIterator.next();
            if (entry.getStoreTime() < nextItemsStoreTimeInWriteBehindQueue) {
                this.evictionStagingAreaIterator.remove();
            }
            this.initStagingAreaIterator();
            if (this.evictionStagingAreaIterator.hasNext()) continue;
            break;
        }
    }

    private long getNextItemsStoreTimeInWriteBehindQueue() {
        DelayedEntry firstEntryInQueue = this.writeBehindQueue.get(0);
        if (firstEntryInQueue == null) {
            return 0L;
        }
        return firstEntryInQueue.getStoreTime();
    }

    private void putEvictionStagingArea(Data key, Object value, long lastUpdateTime) {
        assert (value != null) : String.format("value is null", new Object[0]);
        assert (lastUpdateTime > 0L) : String.format("lastUpdateTime should be greater than 0, but found %d", lastUpdateTime);
        if (!this.mapContainer.isWriteBehindMapStoreEnabled()) {
            return;
        }
        long storeTime = lastUpdateTime + this.getWriteDelayTime();
        DelayedEntry delayedEntry = DelayedEntry.createWithNullKey(value, storeTime);
        this.evictionStagingArea.put(key, delayedEntry);
    }

    private Object getFromEvictionStagingArea(Data key) {
        if (!this.mapContainer.isWriteBehindMapStoreEnabled()) {
            return null;
        }
        DelayedEntry entryWithNullKey = this.evictionStagingArea.get(key);
        if (entryWithNullKey == null) {
            return null;
        }
        return this.mapService.toObject(entryWithNullKey.getValue());
    }

    private void removeFromEvictionStagingArea(Data key) {
        if (!this.mapContainer.isWriteBehindMapStoreEnabled()) {
            return;
        }
        DelayedEntry value = this.evictionStagingArea.remove(key);
        if (value == null) {
            return;
        }
    }

    private boolean isInEvictionStagingArea(Data key, long now) {
        if (!this.mapContainer.isWriteBehindMapStoreEnabled()) {
            return false;
        }
        DelayedEntry entry = this.evictionStagingArea.get(key);
        if (entry == null) {
            return false;
        }
        long storeTime = entry.getStoreTime();
        return now < storeTime;
    }

    private Map<Object, Object> getFromEvictionStagingArea(Set<Data> keys) {
        if (!this.mapContainer.isWriteBehindMapStoreEnabled()) {
            return Collections.emptyMap();
        }
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        for (Data key : keys) {
            Object valueFromEvictionStagingArea = this.getFromEvictionStagingArea(key);
            if (valueFromEvictionStagingArea == null) continue;
            map.put(this.mapService.toObject(key), valueFromEvictionStagingArea);
        }
        return map;
    }

    @Override
    public boolean isExpirable() {
        return this.expirable;
    }

    @Override
    public void loadAllFromStore(Collection<Data> keys, boolean replaceExistingValues) {
        if (keys.isEmpty()) {
            return;
        }
        this.loaded.set(false);
        NodeEngine nodeEngine = this.mapService.getNodeEngine();
        ExecutionService executionService = nodeEngine.getExecutionService();
        executionService.submit("hz:map-loadAllKeys", new LoadAllKeysTask(keys, replaceExistingValues));
    }

    private boolean hasWaitingWriteBehindDeleteOperation(Data key) {
        return this.mapContainer.isWriteBehindMapStoreEnabled() && this.writeBehindWaitingDeletions.contains(key);
    }

    private Record evictIfNotReachable(Record record) {
        if (record == null) {
            return null;
        }
        if (this.isLocked(record.getKey())) {
            return record;
        }
        if (this.isReachable(record)) {
            return record;
        }
        Data key = record.getKey();
        Object value = record.getValue();
        this.evict(key);
        this.doPostEvictionOperations(key, value);
        return null;
    }

    private boolean isReachable(Record record) {
        long now = this.getNow();
        return this.isReachable(record, now);
    }

    private boolean isReachable(Record record, long time) {
        Record result = this.mapContainer.getReachabilityHandlerChain().isReachable(record, -1L, time);
        return result != null;
    }

    private void doPostEvictionOperations(Data key, Object value) {
        if (this.mapService.isNearCacheAndInvalidationEnabled(this.name)) {
            this.mapService.invalidateAllNearCaches(this.name, key);
        }
        EvictionHelper.fireEvent(key, value, this.name, this.mapService);
    }

    private void accessRecord(Record record, long now) {
        this.increaseRecordEvictionCriteriaNumber(record, this.mapContainer.getMapConfig().getEvictionPolicy());
        record.setLastAccessTime(now);
        record.onAccess();
    }

    private void accessRecord(Record record) {
        long now = this.getNow();
        this.accessRecord(record, now);
    }

    private long getNow() {
        return Clock.currentTimeMillis();
    }

    private void increaseRecordEvictionCriteriaNumber(Record record, MapConfig.EvictionPolicy evictionPolicy) {
        switch (evictionPolicy) {
            case LRU: {
                ++this.lruAccessSequenceNumber;
                record.setEvictionCriteriaNumber(this.lruAccessSequenceNumber);
                break;
            }
            case LFU: {
                record.setEvictionCriteriaNumber(record.getEvictionCriteriaNumber() + 1L);
                break;
            }
            case NONE: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Not an appropriate eviction policy [" + (Object)((Object)evictionPolicy) + ']');
            }
        }
    }

    private void saveIndex(Record record) {
        Data dataKey = record.getKey();
        IndexService indexService = this.mapContainer.getIndexService();
        if (indexService.hasIndex()) {
            SerializationService ss = this.mapService.getSerializationService();
            QueryEntry queryableEntry = new QueryEntry(ss, dataKey, dataKey, record.getValue());
            indexService.saveEntryIndex(queryableEntry);
        }
    }

    private Object mapStoreWrite(Data key, Object value, Record record, long now) {
        MapStoreWrapper store = this.mapContainer.getStore();
        if (store == null) {
            return value;
        }
        if (this.getWriteDelayTime() < 1L) {
            Object objectValue = this.mapService.toObject(value);
            store.store(this.mapService.toObject(key), objectValue);
            if (record != null) {
                record.onStore();
            }
            return store.isPostProcessingMapStore() ? objectValue : value;
        }
        this.addToDelayedStore(key, value, now);
        return value;
    }

    private void mapStoreDelete(Record record, Data key, long now) {
        MapStoreWrapper store = this.mapContainer.getStore();
        if (store == null) {
            return;
        }
        long writeDelay = this.getWriteDelayTime();
        if (writeDelay < 1L) {
            store.delete(this.mapService.toObject(key));
            if (record != null) {
                record.onStore();
            }
            return;
        }
        this.addToDelayedStore(key, null, now);
    }

    private void addToDelayedStore(Data key, Object value, long now) {
        if (!this.mapContainer.isWriteBehindMapStoreEnabled()) {
            return;
        }
        long writeDelay = this.getWriteDelayTime();
        long storeTime = now + writeDelay;
        DelayedEntry<Data, Object> delayedEntry = DelayedEntry.create(key, value, storeTime, this.partitionId);
        if (value == null) {
            this.addToWriteBehindWaitingDeletions(key);
            this.removeFromEvictionStagingArea(key);
        }
        this.writeBehindQueue.offer(delayedEntry);
    }

    private long getWriteDelayTime() {
        return this.mapContainer.getWriteDelayMillis();
    }

    private void updateTtl(Record record, long ttl) {
        if (ttl < 0L) {
            return;
        }
        record.setTtl(ttl);
        if (record.getStatistics() != null) {
            long expirationTime = ttl == 0L ? Long.MAX_VALUE : this.getNow() + ttl;
            record.getStatistics().setExpirationTime(expirationTime);
        }
    }

    private void markRecordStoreExpirable(long ttl) {
        if (ttl > 0L) {
            this.expirable = true;
        }
    }

    private void updateSizeEstimator(long recordSize) {
        this.sizeEstimator.add(recordSize);
    }

    private long calculateRecordSize(Record record) {
        return this.sizeEstimator.getCost(record);
    }

    private long calculateRecordSize(Collection<Record> collection) {
        long totalSize = 0L;
        for (Record record : collection) {
            totalSize += this.calculateRecordSize(record);
        }
        return totalSize;
    }

    private void resetSizeEstimator() {
        this.sizeEstimator.reset();
    }

    private void setRecordValue(Record record, Object value, long now) {
        this.accessRecord(record, now);
        record.setLastUpdateTime(now);
        record.onUpdate();
        this.recordFactory.setValue(record, value);
    }

    private void removeIndex(Data key) {
        IndexService indexService = this.mapContainer.getIndexService();
        if (indexService.hasIndex()) {
            indexService.removeEntryIndex(key);
        }
    }

    private void removeIndex(Set<Data> keys) {
        IndexService indexService = this.mapContainer.getIndexService();
        if (indexService.hasIndex()) {
            for (Data key : keys) {
                indexService.removeEntryIndex(key);
            }
        }
    }

    private WriteBehindQueue<DelayedEntry> createWriteBehindQueue() {
        boolean writeBehindMapStoreEnabled = this.mapContainer.isWriteBehindMapStoreEnabled();
        if (!writeBehindMapStoreEnabled) {
            return WriteBehindQueues.emptyWriteBehindQueue();
        }
        AtomicInteger counter = this.mapService.getWriteBehindQueueItemCounter();
        int maxPerNodeWriteBehindQueueSize = this.mapService.getMaxPerNodeSizeOfWriteBehindQueue();
        return WriteBehindQueues.createDefaultWriteBehindQueue(maxPerNodeWriteBehindQueueSize, counter);
    }

    private Map<Data, DelayedEntry> createEvictionStagingArea() {
        boolean writeBehindMapStoreEnabled = this.mapContainer.isWriteBehindMapStoreEnabled();
        if (!writeBehindMapStoreEnabled) {
            return Collections.emptyMap();
        }
        return new ConcurrentHashMap<Data, DelayedEntry>();
    }

    private Set<Data> createWriteBehindWaitingDeletionsSet() {
        boolean writeBehindMapStoreEnabled = this.mapContainer.isWriteBehindMapStoreEnabled();
        if (!writeBehindMapStoreEnabled) {
            return Collections.emptySet();
        }
        return Collections.newSetFromMap(new ConcurrentHashMap());
    }

    private boolean isRecordStoreExpirable() {
        return this.mapContainer.getMapConfig().getMaxIdleSeconds() > 0 || this.mapContainer.getMapConfig().getTimeToLiveSeconds() > 0;
    }

    private LockStore createLockStore() {
        NodeEngine nodeEngine = this.mapService.getNodeEngine();
        LockService lockService = (LockService)nodeEngine.getSharedService("hz:impl:lockService");
        if (lockService == null) {
            return null;
        }
        return lockService.createLockStore(this.partitionId, new DefaultObjectNamespace("hz:impl:mapService", this.name));
    }

    private int getLoadBatchSize() {
        return this.mapService.getNodeEngine().getGroupProperties().MAP_LOAD_CHUNK_SIZE.getInteger();
    }

    private void loadKeys(Collection<Data> keys, boolean replaceExistingValues) {
        if (!replaceExistingValues) {
            this.removeExistingKeys(keys);
        }
        this.removeUnloadableKeys(keys);
        if (keys.isEmpty()) {
            this.loaded.set(true);
            return;
        }
        List<Object> objectKeys = this.convertDataKeysToObject(keys);
        this.doBatchLoad(objectKeys);
    }

    private void doBatchLoad(List<Object> keys) {
        Queue<List<Object>> batchChunks = this.createBatchChunks(keys);
        int size = batchChunks.size();
        AtomicInteger finishedBatchCounter = new AtomicInteger(size);
        while (!batchChunks.isEmpty()) {
            List<Object> chunk = batchChunks.poll();
            List<Data> keyValueSequence = this.loadAndGet(chunk);
            if (keyValueSequence.isEmpty()) {
                if (finishedBatchCounter.decrementAndGet() != 0) continue;
                this.loaded.set(true);
                continue;
            }
            this.sendOperation(keyValueSequence, finishedBatchCounter);
        }
    }

    private Queue<List<Object>> createBatchChunks(List<Object> keys) {
        List<Object> tmpKeys;
        LinkedList<List<Object>> chunks = new LinkedList<List<Object>>();
        int loadBatchSize = this.getLoadBatchSize();
        int page = 0;
        while ((tmpKeys = this.getBatchChunk(keys, loadBatchSize, page++)) != null) {
            chunks.add(tmpKeys);
        }
        return chunks;
    }

    private List<Data> loadAndGet(List<Object> keys) {
        Map entries = Collections.emptyMap();
        try {
            entries = this.mapContainer.getStore().loadAll(keys);
        }
        catch (Throwable t) {
            this.logger.warning("Could not load keys from map store", t);
        }
        return this.getKeyValueSequence(entries);
    }

    private List<Data> getKeyValueSequence(Map<Object, Object> entries) {
        if (entries == null || entries.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Data> keyValueSequence = new ArrayList<Data>();
        for (Map.Entry<Object, Object> entry : entries.entrySet()) {
            Object key = entry.getKey();
            Object value = entry.getValue();
            Data dataKey = this.mapService.toData(key);
            Data dataValue = this.mapService.toData(value);
            keyValueSequence.add(dataKey);
            keyValueSequence.add(dataValue);
        }
        return keyValueSequence;
    }

    private List<Object> getBatchChunk(List<Object> list, int batchSize, int chunkNumber) {
        if (list == null || list.isEmpty()) {
            return null;
        }
        int start = chunkNumber * batchSize;
        int end = Math.min(start + batchSize, list.size());
        if (start >= end) {
            return null;
        }
        return list.subList(start, end);
    }

    private void sendOperation(List<Data> keyValueSequence, AtomicInteger finishedBatchCounter) {
        OperationService operationService = this.mapService.getNodeEngine().getOperationService();
        Operation operation = this.createOperation(keyValueSequence, finishedBatchCounter);
        operationService.executeOperation(operation);
    }

    private Operation createOperation(List<Data> keyValueSequence, final AtomicInteger finishedBatchCounter) {
        NodeEngine nodeEngine = this.mapService.getNodeEngine();
        PutFromLoadAllOperation operation = new PutFromLoadAllOperation(this.name, keyValueSequence);
        operation.setNodeEngine(nodeEngine);
        operation.setResponseHandler(new ResponseHandler(){

            @Override
            public void sendResponse(Object obj) {
                if (finishedBatchCounter.decrementAndGet() == 0) {
                    DefaultRecordStore.this.loaded.set(true);
                }
            }

            @Override
            public boolean isLocal() {
                return true;
            }
        });
        operation.setPartitionId(this.partitionId);
        OperationAccessor.setCallerAddress(operation, nodeEngine.getThisAddress());
        operation.setCallerUuid(nodeEngine.getLocalMember().getUuid());
        operation.setServiceName("hz:impl:mapService");
        return operation;
    }

    private List<Object> convertDataKeysToObject(Collection<Data> keys) {
        if (keys.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Object> objectKeys = new ArrayList<Object>(keys.size());
        for (Data key : keys) {
            Object objectKey = this.mapService.toObject(key);
            objectKeys.add(objectKey);
        }
        return objectKeys;
    }

    private void removeExistingKeys(Collection<Data> keys) {
        if (keys == null || keys.isEmpty()) {
            return;
        }
        ConcurrentMap<Data, Record> records = this.records;
        Iterator<Data> iterator = keys.iterator();
        while (iterator.hasNext()) {
            Data nextKey = iterator.next();
            if (!records.containsKey(nextKey)) continue;
            iterator.remove();
        }
    }

    private void removeUnloadableKeys(Collection<Data> keys) {
        if (keys == null || keys.isEmpty()) {
            return;
        }
        long now = this.getNow();
        Iterator<Data> iterator = keys.iterator();
        while (iterator.hasNext()) {
            Data key = iterator.next();
            if (this.loadable(key, this, now)) continue;
            iterator.remove();
        }
    }

    private boolean loadable(Data key, RecordStore recordStore, long now) {
        if (!this.mapContainer.isWriteBehindMapStoreEnabled()) {
            return true;
        }
        if (this.isInWriteBehindWaitingDeletions(key) || this.isInEvictionStagingArea(key, now)) {
            return false;
        }
        Record record = recordStore.getRecord(key);
        long scheduledStoreTime = record.getLastUpdateTime() + this.mapContainer.getWriteDelayMillis();
        return now >= scheduledStoreTime;
    }

    private final class MapLoadAllTask
    implements Runnable {
        private final Map<Data, Object> keys;
        private final AtomicInteger checkIfMapLoaded;

        private MapLoadAllTask(Map<Data, Object> keys, AtomicInteger checkIfMapLoaded) {
            this.keys = keys;
            this.checkIfMapLoaded = checkIfMapLoaded;
        }

        @Override
        public void run() {
            NodeEngine nodeEngine = DefaultRecordStore.this.mapService.getNodeEngine();
            try {
                Map values = DefaultRecordStore.this.mapContainer.getStore().loadAll(this.keys.values());
                if (values == null || values.isEmpty()) {
                    if (this.checkIfMapLoaded.decrementAndGet() == 0) {
                        DefaultRecordStore.this.loaded.set(true);
                    }
                    return;
                }
                MapEntrySet entrySet = new MapEntrySet();
                for (Data dataKey : this.keys.keySet()) {
                    Object key = this.keys.get(dataKey);
                    Object value = values.get(key);
                    if (value == null) continue;
                    Data dataValue = DefaultRecordStore.this.mapService.toData(value);
                    entrySet.add(dataKey, dataValue);
                }
                PutAllOperation operation = new PutAllOperation(DefaultRecordStore.this.name, entrySet, true);
                operation.setNodeEngine(nodeEngine);
                operation.setResponseHandler(new ResponseHandler(){

                    @Override
                    public void sendResponse(Object obj) {
                        if (MapLoadAllTask.this.checkIfMapLoaded.decrementAndGet() == 0) {
                            DefaultRecordStore.this.loaded.set(true);
                        }
                    }

                    @Override
                    public boolean isLocal() {
                        return true;
                    }
                });
                operation.setPartitionId(DefaultRecordStore.this.partitionId);
                OperationAccessor.setCallerAddress(operation, nodeEngine.getThisAddress());
                operation.setCallerUuid(nodeEngine.getLocalMember().getUuid());
                operation.setServiceName("hz:impl:mapService");
                nodeEngine.getOperationService().executeOperation(operation);
            }
            catch (Exception e) {
                DefaultRecordStore.this.logger.warning("Exception while load all task:" + e.toString());
            }
        }
    }

    private final class LoadAllKeysTask
    implements Runnable {
        private final Collection<Data> keys;
        private final boolean replaceExistingValues;

        private LoadAllKeysTask(Collection<Data> keys, boolean replaceExistingValues) {
            this.keys = keys;
            this.replaceExistingValues = replaceExistingValues;
        }

        @Override
        public void run() {
            DefaultRecordStore.this.loadKeys(this.keys, this.replaceExistingValues);
        }
    }
}

