/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client;

import com.hazelcast.client.ClientEndpoint;
import com.hazelcast.client.ClientEngineImpl;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.nio.Connection;
import com.hazelcast.util.UuidUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class ClientEndpointManager {
    ILogger logger = Logger.getLogger(ClientEndpointManager.class);
    private final ClientEngineImpl clientEngine;
    private final ConcurrentMap<Connection, ClientEndpoint> endpoints = new ConcurrentHashMap<Connection, ClientEndpoint>();

    public ClientEndpointManager(ClientEngineImpl clientEngine) {
        this.clientEngine = clientEngine;
    }

    Set<ClientEndpoint> getEndpoints(String uuid) {
        HashSet<ClientEndpoint> endpointSet = new HashSet<ClientEndpoint>();
        for (ClientEndpoint endpoint : this.endpoints.values()) {
            if (!uuid.equals(endpoint.getUuid())) continue;
            endpointSet.add(endpoint);
        }
        return endpointSet;
    }

    ClientEndpoint getEndpoint(Connection conn) {
        return (ClientEndpoint)this.endpoints.get(conn);
    }

    ClientEndpoint createEndpoint(Connection conn) {
        if (!conn.live()) {
            this.logger.severe("Can't create and endpoint for a dead connection");
            return null;
        }
        String clientUuid = UuidUtil.createClientUuid(conn.getEndPoint());
        ClientEndpoint endpoint = new ClientEndpoint(this.clientEngine, conn, clientUuid);
        if (this.endpoints.putIfAbsent(conn, endpoint) != null) {
            this.logger.severe("An endpoint already exists for connection:" + conn);
        }
        return endpoint;
    }

    ClientEndpoint removeEndpoint(Connection connection) {
        return this.removeEndpoint(connection, false);
    }

    ClientEndpoint removeEndpoint(Connection connection, boolean closeImmediately) {
        ClientEndpoint endpoint = (ClientEndpoint)this.endpoints.remove(connection);
        this.clientEngine.destroyEndpoint(endpoint, closeImmediately);
        return endpoint;
    }

    void clear() {
        this.endpoints.clear();
    }

    Collection<ClientEndpoint> values() {
        return this.endpoints.values();
    }

    int size() {
        return this.endpoints.size();
    }
}

