/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.ascii.memcache;

import com.hazelcast.ascii.AbstractTextCommand;
import com.hazelcast.ascii.TextCommandConstants;
import java.nio.ByteBuffer;

public class TouchCommand
extends AbstractTextCommand {
    String key;
    int expiration;
    boolean noreply;
    ByteBuffer response;

    public TouchCommand(TextCommandConstants.TextCommandType type, String key, int expiration, boolean noReply) {
        super(type);
        this.key = key;
        this.expiration = expiration;
        this.noreply = noReply;
    }

    @Override
    public boolean writeTo(ByteBuffer destination) {
        if (this.response == null) {
            this.response = ByteBuffer.wrap(STORED);
        }
        while (destination.hasRemaining() && this.response.hasRemaining()) {
            destination.put(this.response.get());
        }
        return !this.response.hasRemaining();
    }

    @Override
    public boolean readFrom(ByteBuffer source) {
        return true;
    }

    @Override
    public boolean shouldReply() {
        return !this.noreply;
    }

    public String getKey() {
        return this.key;
    }

    public int getExpiration() {
        return this.expiration;
    }

    public void setResponse(byte[] value) {
        this.response = ByteBuffer.wrap(value);
    }
}

