/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.util;

public final class Clock {
    private static final ClockImpl CLOCK;

    private Clock() {
    }

    public static long currentTimeMillis() {
        return CLOCK.currentTimeMillis();
    }

    static {
        String clockOffset = System.getProperty("com.hazelcast.clock.offset");
        long offset = 0L;
        if (clockOffset != null) {
            try {
                offset = Long.parseLong(clockOffset);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        CLOCK = offset == 0L ? new SystemClock() : new SystemOffsetClock(offset);
    }

    private static final class SystemOffsetClock
    extends ClockImpl {
        private final long offset;

        private SystemOffsetClock(long offset) {
            this.offset = offset;
        }

        @Override
        protected long currentTimeMillis() {
            return System.currentTimeMillis() + this.offset;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("SystemOffsetClock");
            sb.append("{offset=").append(this.offset);
            sb.append('}');
            return sb.toString();
        }
    }

    private static final class SystemClock
    extends ClockImpl {
        private SystemClock() {
        }

        @Override
        protected long currentTimeMillis() {
            return System.currentTimeMillis();
        }

        public String toString() {
            return "SystemClock";
        }
    }

    private static abstract class ClockImpl {
        private ClockImpl() {
        }

        protected abstract long currentTimeMillis();
    }
}

