/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.replicatedmap.record;

import com.hazelcast.core.Member;
import com.hazelcast.instance.MemberImpl;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.replicatedmap.operation.ReplicatedMapDataSerializerHook;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;

public final class VectorClock
implements IdentifiedDataSerializable {
    final Map<Member, AtomicInteger> clocks = new ConcurrentHashMap<Member, AtomicInteger>();

    void incrementClock(Member localMember) {
        AtomicInteger clock = this.clocks.get(localMember);
        if (clock != null) {
            clock.incrementAndGet();
        } else {
            this.clocks.put(localMember, new AtomicInteger(1));
        }
    }

    void applyVector(VectorClock update) {
        for (Member m : update.clocks.keySet()) {
            AtomicInteger updateClock;
            AtomicInteger currentClock = this.clocks.get(m);
            if (!this.smaller(currentClock, updateClock = update.clocks.get(m))) continue;
            this.clocks.put(m, new AtomicInteger(updateClock.get()));
        }
    }

    @Override
    public void writeData(ObjectDataOutput dataOutput) throws IOException {
        dataOutput.writeInt(this.clocks.size());
        for (Map.Entry<Member, AtomicInteger> entry : this.clocks.entrySet()) {
            entry.getKey().writeData(dataOutput);
            dataOutput.writeInt(entry.getValue().get());
        }
    }

    @Override
    public void readData(ObjectDataInput dataInput) throws IOException {
        int size = dataInput.readInt();
        for (int i = 0; i < size; ++i) {
            MemberImpl m = new MemberImpl();
            m.readData(dataInput);
            int clock = dataInput.readInt();
            this.clocks.put(m, new AtomicInteger(clock));
        }
    }

    @Override
    public int getId() {
        return 0;
    }

    @Override
    public int getFactoryId() {
        return ReplicatedMapDataSerializerHook.F_ID;
    }

    public String toString() {
        return "Vector{clocks=" + this.clocks + '}';
    }

    private boolean smaller(AtomicInteger int1, AtomicInteger int2) {
        int i1 = int1 == null ? 0 : int1.get();
        int i2 = int2 == null ? 0 : int2.get();
        return i1 < i2;
    }

    static VectorClock copyVector(VectorClock vectorClock) {
        VectorClock copy = new VectorClock();
        Map<Member, AtomicInteger> clocks = copy.clocks;
        for (Map.Entry<Member, AtomicInteger> entry : vectorClock.clocks.entrySet()) {
            MemberImpl member = new MemberImpl((MemberImpl)entry.getKey());
            AtomicInteger value = new AtomicInteger(entry.getValue().intValue());
            clocks.put(member, value);
        }
        return copy;
    }

    static boolean happenedBefore(VectorClock x, VectorClock y) {
        HashSet<Member> members = new HashSet<Member>(x.clocks.keySet());
        members.addAll(y.clocks.keySet());
        boolean hasLesser = false;
        for (Member m : members) {
            int yi;
            int xi = x.clocks.get(m) != null ? x.clocks.get(m).get() : 0;
            int n = yi = y.clocks.get(m) != null ? y.clocks.get(m).get() : 0;
            if (xi > yi) {
                return false;
            }
            if (xi >= yi) continue;
            hasLesser = true;
        }
        return hasLesser;
    }
}

