/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.replicatedmap.record;

import com.hazelcast.config.ReplicatedMapConfig;
import com.hazelcast.replicatedmap.record.ReplicatedRecord;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

class InternalReplicatedMapStorage<K, V> {
    private final ConcurrentMap<K, ReplicatedRecord<K, V>> storage = new ConcurrentHashMap<K, ReplicatedRecord<K, V>>();
    private final AtomicBoolean loaded = new AtomicBoolean(false);
    private final Lock waitForLoadedLock = new ReentrantLock();
    private final Condition waitForLoadedCondition = this.waitForLoadedLock.newCondition();
    private final ReplicatedMapConfig replicatedMapConfig;
    private final String name;

    InternalReplicatedMapStorage(ReplicatedMapConfig replicatedMapConfig) {
        this.name = replicatedMapConfig.getName();
        this.replicatedMapConfig = replicatedMapConfig;
    }

    public ReplicatedRecord<K, V> get(Object key) {
        return (ReplicatedRecord)this.storage.get(key);
    }

    public ReplicatedRecord<K, V> put(K key, ReplicatedRecord<K, V> replicatedRecord) {
        return this.storage.put(key, replicatedRecord);
    }

    public boolean remove(K key, ReplicatedRecord<K, V> replicatedRecord) {
        return this.storage.remove(key, replicatedRecord);
    }

    public boolean containsKey(Object key) {
        return this.storage.containsKey(key);
    }

    public Set<Map.Entry<K, ReplicatedRecord<K, V>>> entrySet() {
        return this.storage.entrySet();
    }

    public Collection<ReplicatedRecord<K, V>> values() {
        return this.storage.values();
    }

    public Set<K> keySet() {
        return this.storage.keySet();
    }

    public void clear() {
        this.storage.clear();
    }

    public boolean isEmpty() {
        return this.storage.isEmpty();
    }

    public int size() {
        return this.storage.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finishLoading() {
        this.loaded.set(true);
        this.waitForLoadedLock.lock();
        try {
            this.waitForLoadedCondition.signalAll();
        }
        finally {
            this.waitForLoadedLock.unlock();
        }
    }

    public boolean isLoaded() {
        return this.loaded.get();
    }

    public void checkState() {
        if (!this.loaded.get() && !this.replicatedMapConfig.isAsyncFillup()) {
            while (true) {
                this.waitForLoadedLock.lock();
                try {
                    if (!this.loaded.get()) {
                        this.waitForLoadedCondition.await();
                    }
                    if (!this.loaded.get()) continue;
                    return;
                }
                catch (InterruptedException e) {
                    String name = this.replicatedMapConfig.getName();
                    throw new IllegalStateException("Synchronous loading of ReplicatedMap '" + name + "' failed.", e);
                }
                finally {
                    this.waitForLoadedLock.unlock();
                    continue;
                }
                break;
            }
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InternalReplicatedMapStorage that = (InternalReplicatedMapStorage)o;
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        return this.storage.equals(that.storage);
    }

    public int hashCode() {
        int result = this.storage.hashCode();
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        return result;
    }
}

