/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.replicatedmap.messages;

import com.hazelcast.core.Member;
import com.hazelcast.instance.MemberImpl;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.replicatedmap.operation.ReplicatedMapDataSerializerHook;
import com.hazelcast.replicatedmap.record.VectorClock;
import java.io.IOException;

public class ReplicationMessage<K, V>
implements IdentifiedDataSerializable {
    private String name;
    private K key;
    private V value;
    private VectorClock vectorClock;
    private Member origin;
    private int updateHash;
    private long ttlMillis;

    public ReplicationMessage() {
    }

    public ReplicationMessage(String name, K key, V v, VectorClock vectorClock, Member origin, int hash, long ttlMillis) {
        this.name = name;
        this.key = key;
        this.value = v;
        this.vectorClock = vectorClock;
        this.origin = origin;
        this.updateHash = hash;
        this.ttlMillis = ttlMillis;
    }

    public String getName() {
        return this.name;
    }

    public K getKey() {
        return this.key;
    }

    public V getValue() {
        return this.value;
    }

    public VectorClock getVectorClock() {
        return this.vectorClock;
    }

    public Member getOrigin() {
        return this.origin;
    }

    public long getTtlMillis() {
        return this.ttlMillis;
    }

    public int getUpdateHash() {
        return this.updateHash;
    }

    public boolean isRemove() {
        return this.value == null;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeUTF(this.name);
        out.writeObject(this.key);
        out.writeObject(this.value);
        this.vectorClock.writeData(out);
        this.origin.writeData(out);
        out.writeInt(this.updateHash);
        out.writeLong(this.ttlMillis);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.name = in.readUTF();
        this.key = in.readObject();
        this.value = in.readObject();
        this.vectorClock = new VectorClock();
        this.vectorClock.readData(in);
        this.origin = new MemberImpl();
        this.origin.readData(in);
        this.updateHash = in.readInt();
        this.ttlMillis = in.readLong();
    }

    @Override
    public int getFactoryId() {
        return ReplicatedMapDataSerializerHook.F_ID;
    }

    @Override
    public int getId() {
        return 2;
    }

    public String toString() {
        return "ReplicationMessage{key=" + this.key + ", value=" + this.value + ", vectorClock=" + this.vectorClock + ", origin=" + this.origin + ", updateHash=" + this.updateHash + ", ttlMillis=" + this.ttlMillis + '}';
    }
}

