/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.replicatedmap.client;

import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Portable;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import com.hazelcast.replicatedmap.client.ReplicatedMapPortableHook;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;

public class ReplicatedMapKeySet
implements Portable {
    private Set keySet;

    ReplicatedMapKeySet() {
    }

    public ReplicatedMapKeySet(Set keySet) {
        this.keySet = keySet;
    }

    public Set getKeySet() {
        return this.keySet;
    }

    @Override
    public void writePortable(PortableWriter writer) throws IOException {
        writer.writeInt("size", this.keySet.size());
        ObjectDataOutput out = writer.getRawDataOutput();
        for (Object key : this.keySet) {
            out.writeObject(key);
        }
    }

    @Override
    public void readPortable(PortableReader reader) throws IOException {
        int size = reader.readInt("size");
        ObjectDataInput in = reader.getRawDataInput();
        this.keySet = new HashSet(size);
        for (int i = 0; i < size; ++i) {
            this.keySet.add(in.readObject());
        }
    }

    @Override
    public int getFactoryId() {
        return ReplicatedMapPortableHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 13;
    }
}

