/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.replicatedmap;

import com.hazelcast.replicatedmap.ReplicatedMapService;
import com.hazelcast.replicatedmap.record.ReplicatedRecordStore;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.util.scheduler.EntryTaskScheduler;
import com.hazelcast.util.scheduler.ScheduledEntry;
import com.hazelcast.util.scheduler.ScheduledEntryProcessor;
import java.util.Collection;

public class ReplicatedMapEvictionProcessor
implements ScheduledEntryProcessor<Object, Object> {
    final NodeEngine nodeEngine;
    final ReplicatedMapService replicatedMapService;
    final String mapName;

    public ReplicatedMapEvictionProcessor(NodeEngine nodeEngine, ReplicatedMapService replicatedMapService, String mapName) {
        this.nodeEngine = nodeEngine;
        this.replicatedMapService = replicatedMapService;
        this.mapName = mapName;
    }

    @Override
    public void process(EntryTaskScheduler<Object, Object> scheduler, Collection<ScheduledEntry<Object, Object>> entries) {
        ReplicatedRecordStore replicatedRecordStore = this.replicatedMapService.getReplicatedRecordStore(this.mapName, false);
        if (replicatedRecordStore != null) {
            for (ScheduledEntry<Object, Object> entry : entries) {
                Object key = entry.getKey();
                replicatedRecordStore.remove(key);
            }
        }
    }
}

