/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.queue.tx;

import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.queue.QueueBackupAwareOperation;
import com.hazelcast.queue.QueueContainer;
import com.hazelcast.queue.tx.TxnRollbackBackupOperation;
import com.hazelcast.spi.Notifier;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.WaitNotifyKey;
import java.io.IOException;

public class TxnRollbackOperation
extends QueueBackupAwareOperation
implements Notifier {
    private long itemId;
    private boolean pollOperation;

    public TxnRollbackOperation() {
    }

    public TxnRollbackOperation(String name, long itemId, boolean pollOperation) {
        super(name);
        this.itemId = itemId;
        this.pollOperation = pollOperation;
    }

    @Override
    public void run() throws Exception {
        QueueContainer container = this.getOrCreateContainer();
        this.response = this.pollOperation ? Boolean.valueOf(container.txnRollbackPoll(this.itemId, false)) : Boolean.valueOf(container.txnRollbackOffer(this.itemId));
    }

    @Override
    public boolean shouldBackup() {
        return true;
    }

    @Override
    public Operation getBackupOperation() {
        return new TxnRollbackBackupOperation(this.name, this.itemId, this.pollOperation);
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeLong(this.itemId);
        out.writeBoolean(this.pollOperation);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.itemId = in.readLong();
        this.pollOperation = in.readBoolean();
    }

    @Override
    public int getId() {
        return 32;
    }

    @Override
    public boolean shouldNotify() {
        return true;
    }

    @Override
    public WaitNotifyKey getNotifiedKey() {
        if (this.pollOperation) {
            return this.getOrCreateContainer().getPollWaitNotifyKey();
        }
        return this.getOrCreateContainer().getOfferWaitNotifyKey();
    }
}

