/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.queue.client;

import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import com.hazelcast.queue.OfferOperation;
import com.hazelcast.queue.client.QueueRequest;
import com.hazelcast.security.permission.QueuePermission;
import com.hazelcast.spi.Operation;
import java.io.IOException;
import java.security.Permission;

public class OfferRequest
extends QueueRequest {
    private Data data;

    public OfferRequest() {
    }

    public OfferRequest(String name, Data data) {
        super(name);
        this.data = data;
    }

    public OfferRequest(String name, long timeoutMillis, Data data) {
        super(name, timeoutMillis);
        this.data = data;
    }

    @Override
    protected Operation prepareOperation() {
        return new OfferOperation(this.name, this.timeoutMillis, this.data);
    }

    @Override
    public int getClassId() {
        return 1;
    }

    @Override
    public void write(PortableWriter writer) throws IOException {
        super.write(writer);
        ObjectDataOutput out = writer.getRawDataOutput();
        this.data.writeData(out);
    }

    @Override
    public void read(PortableReader reader) throws IOException {
        super.read(reader);
        ObjectDataInput in = reader.getRawDataInput();
        this.data = new Data();
        this.data.readData(in);
    }

    @Override
    public Permission getRequiredPermission() {
        return new QueuePermission(this.name, "add");
    }
}

