/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.nio;

import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.IOService;
import com.hazelcast.nio.TcpIpConnectionManager;
import com.hazelcast.util.Clock;

public class ConnectionMonitor {
    final ILogger logger;
    final TcpIpConnectionManager connectionManager;
    final IOService ioService;
    final Address endPoint;
    final long minInterval;
    final int maxFaults;
    int faults;
    long lastFaultTime;

    public ConnectionMonitor(TcpIpConnectionManager connectionManager, Address endPoint) {
        this.connectionManager = connectionManager;
        this.endPoint = endPoint;
        this.ioService = connectionManager.getIOHandler();
        this.minInterval = this.ioService.getConnectionMonitorInterval();
        this.maxFaults = this.ioService.getConnectionMonitorMaxFaults();
        this.logger = this.ioService.getLogger(this.getClass().getName());
    }

    public Address getEndPoint() {
        return this.endPoint;
    }

    public synchronized void onError(Throwable t) {
        String errorMessage = "An error occurred on connection to " + this.endPoint + this.getCauseDescription(t);
        this.logger.finest(errorMessage);
        this.ioService.getSystemLogService().logConnection(errorMessage);
        long now = Clock.currentTimeMillis();
        long last = this.lastFaultTime;
        if (now - last > this.minInterval) {
            if (this.faults++ >= this.maxFaults) {
                String removeEndpointMessage = "Removing connection to endpoint " + this.endPoint + this.getCauseDescription(t);
                this.logger.warning(removeEndpointMessage);
                this.ioService.getSystemLogService().logConnection(removeEndpointMessage);
                this.ioService.removeEndpoint(this.endPoint);
            }
            this.lastFaultTime = now;
        }
    }

    public synchronized void reset() {
        String resetMessage = "Resetting connection monitor for endpoint " + this.endPoint;
        this.logger.finest(resetMessage);
        this.ioService.getSystemLogService().logConnection(resetMessage);
        this.faults = 0;
        this.lastFaultTime = 0L;
    }

    private String getCauseDescription(Throwable t) {
        StringBuilder s = new StringBuilder(" Cause => ");
        if (t != null) {
            s.append(t.getClass().getName()).append(" {").append(t.getMessage()).append("}");
        } else {
            s.append("Unknown");
        }
        return s.append(", Error-Count: ").append(this.faults + 1).toString();
    }
}

