/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.writebehind;

import com.hazelcast.cluster.ClusterService;
import com.hazelcast.core.MapStore;
import com.hazelcast.logging.ILogger;
import com.hazelcast.map.MapService;
import com.hazelcast.map.PartitionContainer;
import com.hazelcast.map.RecordStore;
import com.hazelcast.map.writebehind.DelayedEntry;
import com.hazelcast.map.writebehind.WriteBehindManager;
import com.hazelcast.map.writebehind.WriteBehindQueue;
import com.hazelcast.map.writebehind.store.MapStoreManager;
import com.hazelcast.map.writebehind.store.MapStoreManagers;
import com.hazelcast.map.writebehind.store.StoreListener;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.partition.InternalPartition;
import com.hazelcast.partition.InternalPartitionService;
import com.hazelcast.spi.ExecutionService;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.util.executor.ExecutorType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

class WriteBehindQueueManager
implements WriteBehindManager {
    private static final String EXECUTOR_NAME_PREFIX = "hz:scheduled:mapstore:";
    private static final int EXECUTOR_DEFAULT_QUEUE_CAPACITY = 10000;
    private static final Comparator<DelayedEntry> DELAYED_ENTRY_COMPARATOR = new Comparator<DelayedEntry>(){

        @Override
        public int compare(DelayedEntry o1, DelayedEntry o2) {
            long s2;
            long s1 = o1.getStoreTime();
            return s1 < (s2 = o2.getStoreTime()) ? -1 : (s1 == s2 ? 0 : 1);
        }
    };
    private final ScheduledExecutorService scheduledExecutor;
    private final StoreProcessor processor;
    private final MapService mapService;
    private final MapStoreManager<DelayedEntry> mapStoreManager;
    private final List<StoreListener> listeners;
    private final ILogger logger;

    WriteBehindQueueManager(String mapName, MapService mapService, MapStore mapStore) {
        this.scheduledExecutor = this.getScheduledExecutorService(mapName, mapService);
        this.mapService = mapService;
        this.logger = mapService.getNodeEngine().getLogger(WriteBehindQueueManager.class);
        this.listeners = new ArrayList<StoreListener>(2);
        this.mapStoreManager = MapStoreManagers.newMapStoreManager(mapService, mapStore, this.listeners);
        this.processor = new StoreProcessor(mapName, mapService, this.mapStoreManager);
    }

    @Override
    public void start() {
        this.scheduledExecutor.scheduleAtFixedRate(this.processor, 1L, 1L, TimeUnit.SECONDS);
    }

    @Override
    public void stop() {
        this.scheduledExecutor.shutdown();
    }

    @Override
    public void addStoreListener(StoreListener storeListener) {
        this.listeners.add(storeListener);
    }

    @Override
    public Collection<Data> flush(WriteBehindQueue<DelayedEntry> queue) {
        if (queue.size() == 0) {
            return Collections.emptyList();
        }
        List<DelayedEntry> sortedDelayedEntries = queue.fetchAndRemoveAll();
        Collections.sort(sortedDelayedEntries, DELAYED_ENTRY_COMPARATOR);
        HashMap<Integer, Collection<DelayedEntry>> failedStoreOpPerPartition = new HashMap<Integer, Collection<DelayedEntry>>();
        this.mapStoreManager.process(sortedDelayedEntries, failedStoreOpPerPartition);
        if (failedStoreOpPerPartition.size() > 0) {
            this.printErrorLog(failedStoreOpPerPartition);
        }
        queue.clear();
        return this.getDataKeys(sortedDelayedEntries);
    }

    @Override
    public ScheduledExecutorService getScheduler() {
        return this.scheduledExecutor;
    }

    private void printErrorLog(Map<Integer, Collection<DelayedEntry>> failsPerPartition) {
        int size = 0;
        Collection<Collection<DelayedEntry>> values = failsPerPartition.values();
        for (Collection<DelayedEntry> value : values) {
            size += value.size();
        }
        String logMessage = String.format("Map store flush operation can not be done for %d entries", size);
        this.logger.severe(logMessage);
    }

    private static List<DelayedEntry> filterLessThanOrEqualToTime(WriteBehindQueue<DelayedEntry> queue, long time, TimeUnit unit) {
        DelayedEntry e;
        if (queue == null || queue.size() == 0) {
            return Collections.emptyList();
        }
        long timeInNanos = unit.toNanos(time);
        List<DelayedEntry> delayedEntries = Collections.emptyList();
        int i = 0;
        while ((e = queue.get(i)) != null) {
            if (i == 0) {
                delayedEntries = new ArrayList<DelayedEntry>();
            }
            if (e.getStoreTime() <= timeInNanos) {
                delayedEntries.add(e);
            }
            ++i;
        }
        return delayedEntries;
    }

    private static void removeProcessed(WriteBehindQueue<DelayedEntry> queue, int numberOfEntriesProcessed) {
        if (queue == null || queue.size() == 0 || numberOfEntriesProcessed < 1) {
            return;
        }
        for (int j = 0; j < numberOfEntriesProcessed; ++j) {
            queue.removeFirst();
        }
    }

    private List<Data> getDataKeys(List<DelayedEntry> sortedDelayedEntries) {
        if (sortedDelayedEntries == null || sortedDelayedEntries.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Data> keys = new ArrayList<Data>(sortedDelayedEntries.size());
        for (DelayedEntry entry : sortedDelayedEntries) {
            keys.add(this.mapService.toData(entry.getKey()));
        }
        return keys;
    }

    private ScheduledExecutorService getScheduledExecutorService(String mapName, MapService mapService) {
        NodeEngine nodeEngine = mapService.getNodeEngine();
        ExecutionService executionService = nodeEngine.getExecutionService();
        String executorName = EXECUTOR_NAME_PREFIX + mapName;
        executionService.register(executorName, 1, 10000, ExecutorType.CACHED);
        return executionService.getScheduledExecutor(executorName);
    }

    private static void removeProcessedEntries(MapService mapService, String mapName, Map<Integer, Integer> partitionToEntryCountHolder, Map<Integer, Collection<DelayedEntry>> failsPerPartition) {
        for (Map.Entry<Integer, Integer> entry : partitionToEntryCountHolder.entrySet()) {
            Integer partitionId = entry.getKey();
            PartitionContainer partitionContainer = mapService.getPartitionContainer(partitionId);
            RecordStore recordStore = partitionContainer.getExistingRecordStore(mapName);
            if (recordStore == null) continue;
            WriteBehindQueue<DelayedEntry> queue = recordStore.getWriteBehindQueue();
            WriteBehindQueueManager.removeProcessed(queue, partitionToEntryCountHolder.get(partitionId));
            Collection<DelayedEntry> fails = failsPerPartition.get(partitionId);
            if (fails == null || fails.isEmpty()) continue;
            queue.addFront(fails);
        }
    }

    private static final class StoreProcessor
    implements Runnable {
        private final String mapName;
        private final MapService mapService;
        private final MapStoreManager mapStoreManager;
        private final long backupRunIntervalTimeInNanos;
        private long lastRunTimeInNanos = StoreProcessor.nowInNanos();

        private StoreProcessor(String mapName, MapService mapService, MapStoreManager mapStoreManager) {
            this.mapName = mapName;
            this.mapService = mapService;
            this.mapStoreManager = mapStoreManager;
            this.backupRunIntervalTimeInNanos = this.getReplicaWaitTimeInNanos();
        }

        private long getReplicaWaitTimeInNanos() {
            return TimeUnit.SECONDS.toNanos(this.mapService.getNodeEngine().getGroupProperties().MAP_REPLICA_WAIT_SECONDS_FOR_SCHEDULED_TASKS.getInteger());
        }

        @Override
        public void run() {
            long now = StoreProcessor.nowInNanos();
            MapService mapService = this.mapService;
            NodeEngine nodeEngine = mapService.getNodeEngine();
            ClusterService clusterService = nodeEngine.getClusterService();
            InternalPartitionService partitionService = nodeEngine.getPartitionService();
            Address thisAddress = clusterService.getThisAddress();
            int partitionCount = partitionService.getPartitionCount();
            Map<Integer, Integer> partitionToEntryCountHolder = Collections.emptyMap();
            List sortedDelayedEntries = Collections.emptyList();
            boolean createLazy = true;
            for (int partitionId = 0; partitionId < partitionCount; ++partitionId) {
                PartitionContainer partitionContainer;
                RecordStore recordStore;
                InternalPartition partition = partitionService.getPartition(partitionId);
                Address owner = partition.getOwnerOrNull();
                if (owner == null || (recordStore = (partitionContainer = mapService.getPartitionContainer(partitionId)).getExistingRecordStore(this.mapName)) == null) continue;
                WriteBehindQueue<DelayedEntry> queue = recordStore.getWriteBehindQueue();
                List delayedEntries = WriteBehindQueueManager.filterLessThanOrEqualToTime(queue, now, TimeUnit.NANOSECONDS);
                if (!owner.equals(thisAddress)) {
                    if (now >= this.lastRunTimeInNanos + this.backupRunIntervalTimeInNanos) continue;
                    this.doInBackup(queue, delayedEntries, partitionId);
                    continue;
                }
                if (delayedEntries.size() == 0) continue;
                if (createLazy) {
                    partitionToEntryCountHolder = new HashMap();
                    sortedDelayedEntries = new ArrayList();
                    createLazy = false;
                }
                partitionToEntryCountHolder.put(partitionId, delayedEntries.size());
                sortedDelayedEntries.addAll(delayedEntries);
            }
            if (sortedDelayedEntries.isEmpty()) {
                return;
            }
            this.lastRunTimeInNanos = StoreProcessor.nowInNanos();
            Collections.sort(sortedDelayedEntries, DELAYED_ENTRY_COMPARATOR);
            HashMap failsPerPartition = new HashMap();
            this.mapStoreManager.process(sortedDelayedEntries, failsPerPartition);
            WriteBehindQueueManager.removeProcessedEntries(mapService, this.mapName, partitionToEntryCountHolder, failsPerPartition);
        }

        private void doInBackup(WriteBehindQueue queue, List<DelayedEntry> delayedEntries, int partitionId) {
            NodeEngine nodeEngine = this.mapService.getNodeEngine();
            ClusterService clusterService = nodeEngine.getClusterService();
            InternalPartitionService partitionService = nodeEngine.getPartitionService();
            Address thisAddress = clusterService.getThisAddress();
            InternalPartition partition = partitionService.getPartition(partitionId);
            Address owner = partition.getOwnerOrNull();
            if (owner != null && !owner.equals(thisAddress)) {
                this.mapStoreManager.callBeforeStoreListeners(delayedEntries);
                WriteBehindQueueManager.removeProcessed(queue, delayedEntries.size());
                this.mapStoreManager.callAfterStoreListeners(delayedEntries);
            }
        }

        private static long nowInNanos() {
            return System.nanoTime();
        }
    }
}

