/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.writebehind;

import com.hazelcast.map.writebehind.WriteBehindQueue;
import java.util.Collection;
import java.util.List;

class SynchronizedWriteBehindQueue<E>
implements WriteBehindQueue<E> {
    private final WriteBehindQueue<E> queue;
    private final Object mutex;

    SynchronizedWriteBehindQueue(WriteBehindQueue<E> queue) {
        if (queue == null) {
            throw new NullPointerException();
        }
        this.queue = queue;
        this.mutex = this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean offer(E e) {
        Object object = this.mutex;
        synchronized (object) {
            return this.queue.offer(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeFirst() {
        Object object = this.mutex;
        synchronized (object) {
            this.queue.removeFirst();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E get(int index) {
        Object object = this.mutex;
        synchronized (object) {
            return this.queue.get(index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(E o) {
        Object object = this.mutex;
        synchronized (object) {
            return this.queue.contains(o);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        Object object = this.mutex;
        synchronized (object) {
            return this.queue.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        Object object = this.mutex;
        synchronized (object) {
            this.queue.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WriteBehindQueue<E> getSnapShot() {
        Object object = this.mutex;
        synchronized (object) {
            return new SynchronizedWriteBehindQueue<E>(this.queue.getSnapShot());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addFront(Collection<E> collection) {
        if (collection == null || collection.isEmpty()) {
            return;
        }
        Object object = this.mutex;
        synchronized (object) {
            this.queue.addFront(collection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addEnd(Collection<E> collection) {
        if (collection == null || collection.isEmpty()) {
            return;
        }
        Object object = this.mutex;
        synchronized (object) {
            this.queue.addEnd(collection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<E> fetchAndRemoveAll() {
        Object object = this.mutex;
        synchronized (object) {
            return this.queue.fetchAndRemoveAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEnabled() {
        Object object = this.mutex;
        synchronized (object) {
            return this.queue.isEnabled();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<E> asList() {
        Object object = this.mutex;
        synchronized (object) {
            return this.queue.asList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shrink() {
        Object object = this.mutex;
        synchronized (object) {
            this.queue.shrink();
        }
    }
}

