/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.operation;

import com.hazelcast.config.MapConfig;
import com.hazelcast.map.MapContainer;
import com.hazelcast.map.MapService;
import com.hazelcast.map.PartitionContainer;
import com.hazelcast.map.RecordStore;
import com.hazelcast.map.record.Record;
import com.hazelcast.map.record.RecordReplicationInfo;
import com.hazelcast.map.writebehind.DelayedEntry;
import com.hazelcast.map.writebehind.WriteBehindQueue;
import com.hazelcast.nio.IOUtil;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.AbstractOperation;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class MapReplicationOperation
extends AbstractOperation {
    private Map<String, Set<RecordReplicationInfo>> data;
    private Map<String, Boolean> mapInitialLoadInfo;
    private Map<String, List<DelayedEntry>> delayedEntries;

    public MapReplicationOperation() {
    }

    public MapReplicationOperation(MapService mapService, PartitionContainer container, int partitionId, int replicaIndex) {
        this.setPartitionId(partitionId).setReplicaIndex(replicaIndex);
        this.data = new HashMap<String, Set<RecordReplicationInfo>>(container.getMaps().size());
        this.mapInitialLoadInfo = new HashMap<String, Boolean>(container.getMaps().size());
        for (Map.Entry entry : container.getMaps().entrySet()) {
            RecordStore recordStore = (RecordStore)entry.getValue();
            MapContainer mapContainer = recordStore.getMapContainer();
            MapConfig mapConfig = mapContainer.getMapConfig();
            if (mapConfig.getTotalBackupCount() < replicaIndex) continue;
            String name = (String)entry.getKey();
            if (mapContainer.getStore() != null) {
                this.mapInitialLoadInfo.put(name, replicaIndex > 0 || recordStore.isLoaded());
            }
            HashSet<RecordReplicationInfo> recordSet = new HashSet<RecordReplicationInfo>();
            for (Map.Entry<Data, Record> recordEntry : recordStore.getReadonlyRecordMap().entrySet()) {
                Record record = recordEntry.getValue();
                RecordReplicationInfo recordReplicationInfo = mapService.createRecordReplicationInfo(record);
                recordSet.add(recordReplicationInfo);
            }
            this.data.put(name, recordSet);
        }
        this.readDelayedEntries(container);
    }

    private void readDelayedEntries(PartitionContainer container) {
        this.delayedEntries = new HashMap<String, List<DelayedEntry>>(container.getMaps().size());
        for (Map.Entry entry : container.getMaps().entrySet()) {
            RecordStore recordStore = (RecordStore)entry.getValue();
            List<DelayedEntry> delayedEntries = recordStore.getWriteBehindQueue().getSnapShot().asList();
            if (delayedEntries != null && delayedEntries.size() == 0) continue;
            this.delayedEntries.put((String)entry.getKey(), delayedEntries);
        }
    }

    @Override
    public void run() {
        MapService mapService = (MapService)this.getService();
        if (this.data != null) {
            for (Map.Entry<String, Object> entry : this.data.entrySet()) {
                Set recordReplicationInfos = (Set)entry.getValue();
                String mapName = entry.getKey();
                RecordStore recordStore = mapService.getRecordStore(this.getPartitionId(), mapName);
                for (RecordReplicationInfo recordReplicationInfo : recordReplicationInfos) {
                    Data key = recordReplicationInfo.getKey();
                    Record newRecord = mapService.createRecord(mapName, key, recordReplicationInfo.getValue(), -1L);
                    mapService.applyRecordInfo(newRecord, recordReplicationInfo);
                    recordStore.putForReplication(key, newRecord);
                }
            }
        }
        if (this.mapInitialLoadInfo != null) {
            for (Map.Entry<String, Object> entry : this.mapInitialLoadInfo.entrySet()) {
                String mapName = entry.getKey();
                RecordStore recordStore = mapService.getRecordStore(this.getPartitionId(), mapName);
                recordStore.setLoaded((Boolean)entry.getValue());
            }
        }
        for (Map.Entry<String, Object> entry : this.delayedEntries.entrySet()) {
            RecordStore recordStore = mapService.getRecordStore(this.getPartitionId(), entry.getKey());
            List replicatedEntries = (List)entry.getValue();
            WriteBehindQueue<DelayedEntry> writeBehindQueue = recordStore.getWriteBehindQueue();
            writeBehindQueue.addEnd(replicatedEntries);
        }
    }

    @Override
    public String getServiceName() {
        return "hz:impl:mapService";
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        int j;
        String name;
        int i;
        int size = in.readInt();
        this.data = new HashMap<String, Set<RecordReplicationInfo>>(size);
        for (i = 0; i < size; ++i) {
            name = in.readUTF();
            int mapSize = in.readInt();
            HashSet<RecordReplicationInfo> recordReplicationInfos = new HashSet<RecordReplicationInfo>(mapSize);
            for (j = 0; j < mapSize; ++j) {
                RecordReplicationInfo recordReplicationInfo = (RecordReplicationInfo)in.readObject();
                recordReplicationInfos.add(recordReplicationInfo);
            }
            this.data.put(name, recordReplicationInfos);
        }
        size = in.readInt();
        this.mapInitialLoadInfo = new HashMap<String, Boolean>(size);
        for (i = 0; i < size; ++i) {
            name = in.readUTF();
            boolean loaded = in.readBoolean();
            this.mapInitialLoadInfo.put(name, loaded);
        }
        size = in.readInt();
        this.delayedEntries = new HashMap<String, List<DelayedEntry>>(size);
        for (i = 0; i < size; ++i) {
            String mapName = in.readUTF();
            int listSize = in.readInt();
            ArrayList<DelayedEntry<Data, Data>> delayedEntriesList = new ArrayList<DelayedEntry<Data, Data>>(listSize);
            for (j = 0; j < listSize; ++j) {
                Data key = IOUtil.readNullableData(in);
                Data value = IOUtil.readNullableData(in);
                long storeTime = in.readLong();
                int partitionId = in.readInt();
                DelayedEntry<Data, Data> entry = DelayedEntry.create(key, value, storeTime, partitionId);
                delayedEntriesList.add(entry);
            }
            this.delayedEntries.put(mapName, delayedEntriesList);
        }
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        out.writeInt(this.data.size());
        for (Map.Entry<String, Set<RecordReplicationInfo>> entry : this.data.entrySet()) {
            out.writeUTF(entry.getKey());
            Set<RecordReplicationInfo> recordReplicationInfos = entry.getValue();
            out.writeInt(recordReplicationInfos.size());
            for (RecordReplicationInfo recordReplicationInfo : recordReplicationInfos) {
                out.writeObject(recordReplicationInfo);
            }
        }
        out.writeInt(this.mapInitialLoadInfo.size());
        for (Map.Entry<String, Object> entry : this.mapInitialLoadInfo.entrySet()) {
            out.writeUTF(entry.getKey());
            out.writeBoolean((Boolean)entry.getValue());
        }
        MapService mapService = (MapService)this.getService();
        out.writeInt(this.delayedEntries.size());
        for (Map.Entry<String, List<DelayedEntry>> entry : this.delayedEntries.entrySet()) {
            out.writeUTF(entry.getKey());
            List<DelayedEntry> delayedEntryList = entry.getValue();
            out.writeInt(delayedEntryList.size());
            for (DelayedEntry e : delayedEntryList) {
                Data key = mapService.toData(e.getKey());
                Data value = mapService.toData(e.getValue());
                IOUtil.writeNullableData(out, key);
                IOUtil.writeNullableData(out, value);
                out.writeLong(e.getStoreTime());
                out.writeInt(e.getPartitionId());
            }
        }
    }

    public boolean isEmpty() {
        return this.data == null || this.data.isEmpty();
    }
}

