/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.operation;

import com.hazelcast.map.MapService;
import com.hazelcast.map.PartitionContainer;
import com.hazelcast.map.RecordStore;
import com.hazelcast.map.eviction.EvictionHelper;
import com.hazelcast.map.operation.AbstractMapOperation;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.PartitionAwareOperation;
import java.io.IOException;
import java.util.List;

public class ClearExpiredOperation
extends AbstractMapOperation
implements PartitionAwareOperation {
    private List expiredKeyValueSequence;

    public ClearExpiredOperation(String name) {
        super(name);
    }

    @Override
    public void run() throws Exception {
        PartitionContainer partitionContainer = this.mapService.getPartitionContainer(this.getPartitionId());
        RecordStore recordStore = partitionContainer.getExistingRecordStore(this.name);
        if (recordStore == null) {
            return;
        }
        this.expiredKeyValueSequence = recordStore.findUnlockedExpiredRecords();
    }

    @Override
    public void afterRun() throws Exception {
        List expiredKeyValueSequence = this.expiredKeyValueSequence;
        if (expiredKeyValueSequence == null || expiredKeyValueSequence.isEmpty()) {
            return;
        }
        MapService mapService = this.mapService;
        String mapName = this.name;
        NodeEngine nodeEngine = this.getNodeEngine();
        Address owner = nodeEngine.getPartitionService().getPartitionOwner(this.getPartitionId());
        boolean isOwner = nodeEngine.getThisAddress().equals(owner);
        int size = expiredKeyValueSequence.size();
        for (int i = 0; i < size; i += 2) {
            Data key = (Data)expiredKeyValueSequence.get(i);
            Object value = expiredKeyValueSequence.get(i + 1);
            mapService.interceptAfterRemove(mapName, value);
            if (mapService.isNearCacheAndInvalidationEnabled(mapName)) {
                mapService.invalidateAllNearCaches(mapName, key);
            }
            if (!isOwner) continue;
            EvictionHelper.fireEvent(key, value, mapName, mapService);
        }
    }

    @Override
    public boolean returnsResponse() {
        return false;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return "ClearExpiredOperation{}";
    }
}

