/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.eviction;

import com.hazelcast.map.eviction.AbstractReachabilityHandler;
import com.hazelcast.map.record.Record;

class IdleReachabilityHandler
extends AbstractReachabilityHandler {
    private final long idleTimeOutInNanos;

    public IdleReachabilityHandler(long idleTimeOutInNanos) {
        assert (idleTimeOutInNanos > 0L) : String.format("Not valid idleTimeOutInNanos %d", idleTimeOutInNanos);
        this.idleTimeOutInNanos = idleTimeOutInNanos;
    }

    @Override
    public Record handle(Record record, long criteria, long timeInNanos) {
        if (record == null) {
            return null;
        }
        long lastAccessTime = record.getLastAccessTime();
        assert (lastAccessTime > 0L);
        assert (timeInNanos > 0L);
        assert (timeInNanos >= lastAccessTime);
        boolean result = timeInNanos - lastAccessTime >= this.idleTimeOutInNanos;
        IdleReachabilityHandler.log("%s is asked for check and said %s", this.getClass().getName(), result);
        return result ? null : record;
    }

    @Override
    public short niceNumber() {
        return 1;
    }
}

