/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.client;

import com.hazelcast.map.client.AbstractMapAddEntryListenerRequest;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import com.hazelcast.query.Predicate;
import java.io.IOException;

public class MapAddEntryListenerRequest
extends AbstractMapAddEntryListenerRequest {
    private Predicate predicate;

    public MapAddEntryListenerRequest() {
    }

    public MapAddEntryListenerRequest(String name, boolean includeValue) {
        super(name, includeValue);
    }

    public MapAddEntryListenerRequest(String name, Data key, boolean includeValue) {
        super(name, key, includeValue);
    }

    public MapAddEntryListenerRequest(String name, Data key, boolean includeValue, Predicate predicate) {
        super(name, key, includeValue);
        this.predicate = predicate;
    }

    @Override
    public int getClassId() {
        return 25;
    }

    @Override
    protected Predicate getPredicate() {
        return this.predicate;
    }

    @Override
    public void write(PortableWriter writer) throws IOException {
        writer.writeUTF("name", this.name);
        writer.writeBoolean("i", this.includeValue);
        boolean hasKey = this.key != null;
        writer.writeBoolean("key", hasKey);
        if (this.predicate == null) {
            writer.writeBoolean("pre", false);
            if (hasKey) {
                ObjectDataOutput out = writer.getRawDataOutput();
                this.key.writeData(out);
            }
        } else {
            writer.writeBoolean("pre", true);
            ObjectDataOutput out = writer.getRawDataOutput();
            out.writeObject(this.predicate);
            if (hasKey) {
                this.key.writeData(out);
            }
        }
    }

    @Override
    public void read(PortableReader reader) throws IOException {
        this.name = reader.readUTF("name");
        this.includeValue = reader.readBoolean("i");
        boolean hasKey = reader.readBoolean("key");
        if (reader.readBoolean("pre")) {
            ObjectDataInput in = reader.getRawDataInput();
            this.predicate = (Predicate)in.readObject();
            if (hasKey) {
                this.key = new Data();
                this.key.readData(in);
            }
        } else if (hasKey) {
            ObjectDataInput in = reader.getRawDataInput();
            this.key = new Data();
            this.key.readData(in);
        }
    }
}

