/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.collection.client;

import com.hazelcast.client.CallableClientRequest;
import com.hazelcast.client.ClientEndpoint;
import com.hazelcast.client.ClientEngine;
import com.hazelcast.client.RetryableRequest;
import com.hazelcast.collection.CollectionEventFilter;
import com.hazelcast.collection.CollectionPortableHook;
import com.hazelcast.core.ItemEvent;
import com.hazelcast.core.ItemEventType;
import com.hazelcast.core.ItemListener;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import com.hazelcast.security.permission.ListPermission;
import com.hazelcast.security.permission.SetPermission;
import com.hazelcast.spi.EventRegistration;
import com.hazelcast.spi.EventService;
import com.hazelcast.spi.impl.PortableItemEvent;
import java.io.IOException;
import java.security.Permission;

public class CollectionAddListenerRequest
extends CallableClientRequest
implements RetryableRequest {
    private String name;
    private boolean includeValue;
    private String serviceName;

    public CollectionAddListenerRequest() {
    }

    public CollectionAddListenerRequest(String name, boolean includeValue) {
        this.name = name;
        this.includeValue = includeValue;
    }

    public Object call() throws Exception {
        final ClientEndpoint endpoint = this.getEndpoint();
        final ClientEngine clientEngine = this.getClientEngine();
        ItemListener listener = new ItemListener(){

            public void itemAdded(ItemEvent item) {
                this.send(item);
            }

            public void itemRemoved(ItemEvent item) {
                this.send(item);
            }

            private void send(ItemEvent event) {
                if (endpoint.live()) {
                    Data item = clientEngine.toData(event.getItem());
                    ItemEventType eventType = event.getEventType();
                    String uuid = event.getMember().getUuid();
                    PortableItemEvent portableItemEvent = new PortableItemEvent(item, eventType, uuid);
                    endpoint.sendEvent(portableItemEvent, CollectionAddListenerRequest.this.getCallId());
                }
            }
        };
        EventService eventService = clientEngine.getEventService();
        CollectionEventFilter filter = new CollectionEventFilter(this.includeValue);
        EventRegistration registration = eventService.registerListener(this.getServiceName(), this.name, filter, listener);
        String registrationId = registration.getId();
        endpoint.setListenerRegistration(this.getServiceName(), this.name, registrationId);
        return registrationId;
    }

    @Override
    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    @Override
    public int getFactoryId() {
        return CollectionPortableHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 9;
    }

    @Override
    public void write(PortableWriter writer) throws IOException {
        writer.writeUTF("n", this.name);
        writer.writeBoolean("i", this.includeValue);
        writer.writeUTF("s", this.serviceName);
    }

    @Override
    public void read(PortableReader reader) throws IOException {
        this.name = reader.readUTF("n");
        this.includeValue = reader.readBoolean("i");
        this.serviceName = reader.readUTF("s");
    }

    @Override
    public Permission getRequiredPermission() {
        if ("hz:impl:listService".equals(this.serviceName)) {
            return new ListPermission(this.name, "listen");
        }
        if ("hz:impl:setService".equals(this.serviceName)) {
            return new SetPermission(this.name, "listen");
        }
        throw new IllegalArgumentException("No service matched!!!");
    }
}

