/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cluster.client;

import com.hazelcast.client.CallableClientRequest;
import com.hazelcast.client.ClientEndpoint;
import com.hazelcast.client.ClientPortableHook;
import com.hazelcast.client.RetryableRequest;
import com.hazelcast.cluster.ClusterServiceImpl;
import com.hazelcast.cluster.MemberAttributeOperationType;
import com.hazelcast.cluster.client.ClientMembershipEvent;
import com.hazelcast.cluster.client.MemberAttributeChange;
import com.hazelcast.core.Member;
import com.hazelcast.core.MemberAttributeEvent;
import com.hazelcast.core.MembershipEvent;
import com.hazelcast.core.MembershipListener;
import com.hazelcast.instance.MemberImpl;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.SerializationService;
import com.hazelcast.spi.impl.SerializableCollection;
import java.security.Permission;
import java.util.ArrayList;
import java.util.Collection;

public final class AddMembershipListenerRequest
extends CallableClientRequest
implements RetryableRequest {
    public Object call() throws Exception {
        ClusterServiceImpl service = (ClusterServiceImpl)this.getService();
        final ClientEndpoint endpoint = this.getEndpoint();
        String registrationId = service.addMembershipListener(new MembershipListener(){

            @Override
            public void memberAdded(MembershipEvent membershipEvent) {
                if (endpoint.live()) {
                    MemberImpl member = (MemberImpl)membershipEvent.getMember();
                    endpoint.sendEvent(new ClientMembershipEvent((Member)member, 1), AddMembershipListenerRequest.this.getCallId());
                }
            }

            @Override
            public void memberRemoved(MembershipEvent membershipEvent) {
                if (endpoint.live()) {
                    MemberImpl member = (MemberImpl)membershipEvent.getMember();
                    endpoint.sendEvent(new ClientMembershipEvent((Member)member, 2), AddMembershipListenerRequest.this.getCallId());
                }
            }

            @Override
            public void memberAttributeChanged(MemberAttributeEvent memberAttributeEvent) {
                if (endpoint.live()) {
                    MemberImpl member = (MemberImpl)memberAttributeEvent.getMember();
                    String uuid = member.getUuid();
                    MemberAttributeOperationType op = memberAttributeEvent.getOperationType();
                    String key = memberAttributeEvent.getKey();
                    Object value = memberAttributeEvent.getValue();
                    MemberAttributeChange memberAttributeChange = new MemberAttributeChange(uuid, op, key, value);
                    endpoint.sendEvent(new ClientMembershipEvent((Member)member, memberAttributeChange), AddMembershipListenerRequest.this.getCallId());
                }
            }
        });
        String name = "hz:core:clusterService";
        endpoint.setListenerRegistration("hz:core:clusterService", "hz:core:clusterService", registrationId);
        Collection<MemberImpl> memberList = service.getMemberList();
        ArrayList<Data> response = new ArrayList<Data>(memberList.size());
        SerializationService serializationService = this.getClientEngine().getSerializationService();
        for (MemberImpl member : memberList) {
            response.add(serializationService.toData(member));
        }
        return new SerializableCollection(response);
    }

    @Override
    public String getServiceName() {
        return "hz:core:clusterService";
    }

    @Override
    public int getFactoryId() {
        return ClientPortableHook.ID;
    }

    @Override
    public int getClassId() {
        return 10;
    }

    @Override
    public Permission getRequiredPermission() {
        return null;
    }
}

