/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.spi.impl;

import com.hazelcast.client.AuthenticationException;
import com.hazelcast.client.ClientImpl;
import com.hazelcast.client.ClientPrincipal;
import com.hazelcast.client.ClientResponse;
import com.hazelcast.client.HazelcastClient;
import com.hazelcast.client.LifecycleServiceImpl;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.config.ClientNetworkConfig;
import com.hazelcast.client.connection.nio.ClientConnection;
import com.hazelcast.client.connection.nio.ClientConnectionManagerImpl;
import com.hazelcast.client.spi.ClientClusterService;
import com.hazelcast.client.spi.impl.ClientInvocationServiceImpl;
import com.hazelcast.client.spi.impl.ClientPartitionServiceImpl;
import com.hazelcast.client.util.AddressHelper;
import com.hazelcast.cluster.MemberAttributeOperationType;
import com.hazelcast.cluster.client.AddMembershipListenerRequest;
import com.hazelcast.cluster.client.ClientMembershipEvent;
import com.hazelcast.cluster.client.MemberAttributeChange;
import com.hazelcast.config.ListenerConfig;
import com.hazelcast.core.Client;
import com.hazelcast.core.Cluster;
import com.hazelcast.core.HazelcastException;
import com.hazelcast.core.InitialMembershipEvent;
import com.hazelcast.core.InitialMembershipListener;
import com.hazelcast.core.LifecycleEvent;
import com.hazelcast.core.Member;
import com.hazelcast.core.MemberAttributeEvent;
import com.hazelcast.core.MembershipEvent;
import com.hazelcast.core.MembershipListener;
import com.hazelcast.instance.MemberImpl;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.ClassLoaderUtil;
import com.hazelcast.nio.IOUtil;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.SerializationService;
import com.hazelcast.spi.impl.SerializableCollection;
import com.hazelcast.util.Clock;
import com.hazelcast.util.UuidUtil;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;

public final class ClientClusterServiceImpl
implements ClientClusterService {
    private static final ILogger LOGGER = Logger.getLogger(ClientClusterService.class);
    private static final int SLEEP_TIME = 1000;
    private final HazelcastClient client;
    private final ClientConnectionManagerImpl connectionManager;
    private final ClusterListenerThread clusterThread;
    private final AtomicReference<Map<Address, MemberImpl>> membersRef = new AtomicReference();
    private final ConcurrentMap<String, MembershipListener> listeners = new ConcurrentHashMap<String, MembershipListener>();

    public ClientClusterServiceImpl(HazelcastClient client) {
        this.client = client;
        this.connectionManager = (ClientConnectionManagerImpl)client.getConnectionManager();
        this.clusterThread = new ClusterListenerThread(client.getThreadGroup(), client.getName() + ".cluster-listener");
        ClientConfig clientConfig = this.getClientConfig();
        List<ListenerConfig> listenerConfigs = client.getClientConfig().getListenerConfigs();
        if (listenerConfigs != null && !listenerConfigs.isEmpty()) {
            for (ListenerConfig listenerConfig : listenerConfigs) {
                EventListener listener = listenerConfig.getImplementation();
                if (listener == null) {
                    try {
                        listener = (EventListener)ClassLoaderUtil.newInstance(clientConfig.getClassLoader(), listenerConfig.getClassName());
                    }
                    catch (Exception e) {
                        LOGGER.severe(e);
                    }
                }
                if (!(listener instanceof MembershipListener)) continue;
                this.addMembershipListenerWithoutInit((MembershipListener)listener);
            }
        }
    }

    @Override
    public MemberImpl getMember(Address address) {
        Map<Address, MemberImpl> members = this.membersRef.get();
        return members != null ? members.get(address) : null;
    }

    @Override
    public MemberImpl getMember(String uuid) {
        Collection<MemberImpl> memberList = this.getMemberList();
        for (MemberImpl member : memberList) {
            if (!uuid.equals(member.getUuid())) continue;
            return member;
        }
        return null;
    }

    @Override
    public Collection<MemberImpl> getMemberList() {
        Map<Address, MemberImpl> members = this.membersRef.get();
        return members != null ? members.values() : Collections.emptySet();
    }

    @Override
    public Address getMasterAddress() {
        Collection<MemberImpl> memberList = this.getMemberList();
        return !memberList.isEmpty() ? memberList.iterator().next().getAddress() : null;
    }

    @Override
    public int getSize() {
        return this.getMemberList().size();
    }

    @Override
    public long getClusterTime() {
        return Clock.currentTimeMillis();
    }

    public Client getLocalClient() {
        ClientPrincipal cp = this.connectionManager.getPrincipal();
        ClientConnection conn = this.clusterThread.conn;
        return new ClientImpl(cp != null ? cp.getUuid() : null, conn != null ? conn.getLocalSocketAddress() : null);
    }

    private SerializationService getSerializationService() {
        return this.client.getSerializationService();
    }

    public String addMembershipListenerWithInit(MembershipListener listener) {
        String id = UuidUtil.buildRandomUuidString();
        this.listeners.put(id, listener);
        if (listener instanceof InitialMembershipListener) {
            Cluster cluster = this.client.getCluster();
            ((InitialMembershipListener)listener).init(new InitialMembershipEvent(cluster, cluster.getMembers()));
        }
        return id;
    }

    public String addMembershipListenerWithoutInit(MembershipListener listener) {
        String id = UUID.randomUUID().toString();
        this.listeners.put(id, listener);
        return id;
    }

    private void initMembershipListener() {
        for (MembershipListener membershipListener : this.listeners.values()) {
            if (!(membershipListener instanceof InitialMembershipListener)) continue;
            Cluster cluster = this.client.getCluster();
            ((InitialMembershipListener)membershipListener).init(new InitialMembershipEvent(cluster, cluster.getMembers()));
        }
    }

    public boolean removeMembershipListener(String registrationId) {
        return this.listeners.remove(registrationId) != null;
    }

    public void start() {
        this.clusterThread.start();
        try {
            this.clusterThread.await();
        }
        catch (InterruptedException e) {
            throw new HazelcastException(e);
        }
        this.initMembershipListener();
    }

    public void stop() {
        this.clusterThread.shutdown();
    }

    private ClientConnection connectToOne(Collection<InetSocketAddress> socketAddresses) throws Exception {
        ClientNetworkConfig networkConfig = this.getClientConfig().getNetworkConfig();
        int connectionAttemptLimit = networkConfig.getConnectionAttemptLimit();
        int connectionAttemptPeriod = networkConfig.getConnectionAttemptPeriod();
        int attempt = 0;
        Exception lastError = null;
        while (true) {
            long nextTry = Clock.currentTimeMillis() + (long)connectionAttemptPeriod;
            for (InetSocketAddress isa : socketAddresses) {
                Address address = new Address(isa);
                try {
                    ClientConnection connection = this.connectionManager.ownerConnection(address);
                    this.fireConnectionEvent(false);
                    return connection;
                }
                catch (IOException e) {
                    lastError = e;
                    LOGGER.finest("IO error during initial connection...", e);
                }
                catch (AuthenticationException e) {
                    lastError = e;
                    LOGGER.warning("Authentication error on " + address, e);
                }
            }
            if (attempt++ >= connectionAttemptLimit) break;
            long remainingTime = nextTry - Clock.currentTimeMillis();
            LOGGER.warning(String.format("Unable to get alive cluster connection, try in %d ms later, attempt %d of %d.", Math.max(0L, remainingTime), attempt, connectionAttemptLimit));
            if (remainingTime <= 0L) continue;
            try {
                Thread.sleep(remainingTime);
            }
            catch (InterruptedException e) {
                break;
            }
        }
        throw new IllegalStateException("Unable to connect to any address in the config!", lastError);
    }

    private void fireConnectionEvent(boolean disconnected) {
        LifecycleServiceImpl lifecycleService = (LifecycleServiceImpl)this.client.getLifecycleService();
        LifecycleEvent.LifecycleState state = disconnected ? LifecycleEvent.LifecycleState.CLIENT_DISCONNECTED : LifecycleEvent.LifecycleState.CLIENT_CONNECTED;
        lifecycleService.fireLifecycleEvent(state);
    }

    private Collection<InetSocketAddress> getConfigAddresses() {
        LinkedList<InetSocketAddress> socketAddresses = new LinkedList<InetSocketAddress>();
        List<String> addresses = this.getClientConfig().getAddresses();
        Collections.shuffle(addresses);
        for (String address : addresses) {
            socketAddresses.addAll(AddressHelper.getSocketAddresses(address));
        }
        return socketAddresses;
    }

    private ClientConfig getClientConfig() {
        return this.client.getClientConfig();
    }

    private String membersString() {
        StringBuilder sb = new StringBuilder("\n\nMembers [");
        Collection<MemberImpl> members = this.getMemberList();
        sb.append(members != null ? members.size() : 0);
        sb.append("] {");
        if (members != null) {
            for (MemberImpl member : members) {
                sb.append("\n\t").append(member);
            }
        }
        sb.append("\n}\n");
        return sb.toString();
    }

    private final class ClusterListenerThread
    extends Thread {
        private volatile ClientConnection conn;
        private final List<MemberImpl> members;
        private final CountDownLatch latch;

        private ClusterListenerThread(ThreadGroup group, String name) {
            super(group, name);
            this.members = new LinkedList<MemberImpl>();
            this.latch = new CountDownLatch(1);
        }

        public void await() throws InterruptedException {
            this.latch.await();
        }

        @Override
        public void run() {
            while (!Thread.currentThread().isInterrupted()) {
                try {
                    if (this.conn == null) {
                        try {
                            this.conn = this.pickConnection();
                        }
                        catch (Exception e) {
                            LOGGER.severe("Error while connecting to cluster!", e);
                            ClientClusterServiceImpl.this.client.getLifecycleService().shutdown();
                            this.latch.countDown();
                            return;
                        }
                    }
                    this.getInvocationService().triggerFailedListeners();
                    this.loadInitialMemberList();
                    this.listenMembershipEvents();
                }
                catch (Exception e) {
                    if (ClientClusterServiceImpl.this.client.getLifecycleService().isRunning()) {
                        if (LOGGER.isFinestEnabled()) {
                            LOGGER.warning("Error while listening cluster events! -> " + this.conn, e);
                        } else {
                            LOGGER.warning("Error while listening cluster events! -> " + this.conn + ", Error: " + e.toString());
                        }
                    }
                    ClientClusterServiceImpl.this.connectionManager.markOwnerConnectionAsClosed();
                    IOUtil.closeResource(this.conn);
                    this.conn = null;
                    ClientClusterServiceImpl.this.fireConnectionEvent(true);
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    this.latch.countDown();
                    break;
                }
            }
        }

        private ClientInvocationServiceImpl getInvocationService() {
            return (ClientInvocationServiceImpl)ClientClusterServiceImpl.this.client.getInvocationService();
        }

        private ClientConnection pickConnection() throws Exception {
            LinkedList<InetSocketAddress> socketAddresses = new LinkedList<InetSocketAddress>();
            if (!this.members.isEmpty()) {
                for (MemberImpl member : this.members) {
                    socketAddresses.add(member.getInetSocketAddress());
                }
                Collections.shuffle(socketAddresses);
            }
            socketAddresses.addAll(ClientClusterServiceImpl.this.getConfigAddresses());
            return ClientClusterServiceImpl.this.connectToOne(socketAddresses);
        }

        private void loadInitialMemberList() throws Exception {
            SerializationService serializationService = ClientClusterServiceImpl.this.getSerializationService();
            AddMembershipListenerRequest request = new AddMembershipListenerRequest();
            SerializableCollection coll = (SerializableCollection)ClientClusterServiceImpl.this.connectionManager.sendAndReceive(request, this.conn);
            Map<String, MemberImpl> prevMembers = Collections.emptyMap();
            if (!this.members.isEmpty()) {
                prevMembers = new HashMap(this.members.size());
                for (MemberImpl member : this.members) {
                    prevMembers.put(member.getUuid(), member);
                }
                this.members.clear();
            }
            for (Data data : coll) {
                this.members.add((MemberImpl)serializationService.toObject(data));
            }
            this.updateMembersRef();
            LOGGER.info(ClientClusterServiceImpl.this.membersString());
            LinkedList<MembershipEvent> events = new LinkedList<MembershipEvent>();
            Set<Member> eventMembers = Collections.unmodifiableSet(new LinkedHashSet<MemberImpl>(this.members));
            for (MemberImpl member : this.members) {
                MemberImpl former = (MemberImpl)prevMembers.remove(member.getUuid());
                if (former != null) continue;
                events.add(new MembershipEvent(ClientClusterServiceImpl.this.client.getCluster(), member, 1, eventMembers));
            }
            for (MemberImpl member : prevMembers.values()) {
                events.add(new MembershipEvent(ClientClusterServiceImpl.this.client.getCluster(), member, 2, eventMembers));
            }
            for (MembershipEvent event : events) {
                this.fireMembershipEvent(event);
            }
            this.latch.countDown();
        }

        private void listenMembershipEvents() throws IOException {
            SerializationService serializationService = ClientClusterServiceImpl.this.getSerializationService();
            while (!Thread.currentThread().isInterrupted()) {
                Data clientResponseData = this.conn.read();
                ClientResponse clientResponse = (ClientResponse)serializationService.toObject(clientResponseData);
                Object eventObject = serializationService.toObject(clientResponse.getResponse());
                ClientMembershipEvent event = (ClientMembershipEvent)eventObject;
                MemberImpl member = (MemberImpl)event.getMember();
                boolean membersUpdated = false;
                if (event.getEventType() == 1) {
                    this.members.add(member);
                    membersUpdated = true;
                } else if (event.getEventType() == 2) {
                    this.members.remove(member);
                    membersUpdated = true;
                } else if (event.getEventType() == 5) {
                    MemberAttributeChange memberAttributeChange = event.getMemberAttributeChange();
                    Map memberMap = (Map)ClientClusterServiceImpl.this.membersRef.get();
                    if (memberMap != null) {
                        for (MemberImpl target : memberMap.values()) {
                            if (!target.getUuid().equals(memberAttributeChange.getUuid())) continue;
                            MemberAttributeOperationType operationType = memberAttributeChange.getOperationType();
                            String key = memberAttributeChange.getKey();
                            Object value = memberAttributeChange.getValue();
                            target.updateAttribute(operationType, key, value);
                            MemberAttributeEvent memberAttributeEvent = new MemberAttributeEvent(ClientClusterServiceImpl.this.client.getCluster(), target, operationType, key, value);
                            this.fireMemberAttributeEvent(memberAttributeEvent);
                            break;
                        }
                    }
                }
                if (!membersUpdated) continue;
                ((ClientPartitionServiceImpl)ClientClusterServiceImpl.this.client.getClientPartitionService()).refreshPartitions();
                this.updateMembersRef();
                LOGGER.info(ClientClusterServiceImpl.this.membersString());
                this.fireMembershipEvent(new MembershipEvent(ClientClusterServiceImpl.this.client.getCluster(), member, event.getEventType(), Collections.unmodifiableSet(new LinkedHashSet<MemberImpl>(this.members))));
            }
        }

        private void fireMembershipEvent(final MembershipEvent event) {
            ClientClusterServiceImpl.this.client.getClientExecutionService().executeInternal(new Runnable(){

                @Override
                public void run() {
                    for (MembershipListener listener : ClientClusterServiceImpl.this.listeners.values()) {
                        if (event.getEventType() == 1) {
                            listener.memberAdded(event);
                            continue;
                        }
                        listener.memberRemoved(event);
                    }
                }
            });
        }

        private void fireMemberAttributeEvent(final MemberAttributeEvent event) {
            ClientClusterServiceImpl.this.client.getClientExecutionService().executeInternal(new Runnable(){

                @Override
                public void run() {
                    for (MembershipListener listener : ClientClusterServiceImpl.this.listeners.values()) {
                        listener.memberAttributeChanged(event);
                    }
                }
            });
        }

        private void updateMembersRef() {
            LinkedHashMap<Address, MemberImpl> map = new LinkedHashMap<Address, MemberImpl>(this.members.size());
            for (MemberImpl member : this.members) {
                map.put(member.getAddress(), member);
            }
            ClientClusterServiceImpl.this.membersRef.set(Collections.unmodifiableMap(map));
        }

        void shutdown() {
            this.interrupt();
            ClientConnection c = this.conn;
            if (c != null) {
                c.close();
            }
        }
    }
}

