/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.connection.nio;

import com.hazelcast.client.connection.nio.ClientAbstractSelectionHandler;
import com.hazelcast.client.connection.nio.ClientConnection;
import com.hazelcast.nio.IOSelector;
import com.hazelcast.nio.SocketWritable;
import com.hazelcast.util.Clock;
import java.nio.ByteBuffer;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;

public class ClientWriteHandler
extends ClientAbstractSelectionHandler
implements Runnable {
    private final Queue<SocketWritable> writeQueue = new ConcurrentLinkedQueue<SocketWritable>();
    private final AtomicBoolean informSelector = new AtomicBoolean(true);
    private final ByteBuffer buffer;
    private boolean ready;
    private SocketWritable lastWritable;
    private volatile long lastHandle;

    public ClientWriteHandler(ClientConnection connection, IOSelector ioSelector, int bufferSize) {
        super(connection, ioSelector);
        this.buffer = ByteBuffer.allocate(bufferSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handle() {
        block13: {
            this.lastHandle = Clock.currentTimeMillis();
            if (!this.connection.live()) {
                return;
            }
            if (this.lastWritable == null && (this.lastWritable = this.poll()) == null && this.buffer.position() == 0) {
                this.ready = true;
                return;
            }
            try {
                boolean complete;
                while (this.buffer.hasRemaining() && this.lastWritable != null && (complete = this.lastWritable.writeTo(this.buffer))) {
                    this.lastWritable = this.poll();
                }
                if (this.buffer.position() <= 0) break block13;
                this.buffer.flip();
                try {
                    this.socketChannel.write(this.buffer);
                }
                catch (Exception e) {
                    this.lastWritable = null;
                    this.handleSocketException(e);
                    this.ready = false;
                    this.registerWrite();
                    return;
                }
                if (this.buffer.hasRemaining()) {
                    this.buffer.compact();
                } else {
                    this.buffer.clear();
                }
            }
            catch (Throwable t) {
                this.logger.severe("Fatal Error at WriteHandler for endPoint: " + this.connection.getEndPoint(), t);
            }
            finally {
                this.ready = false;
                this.registerWrite();
            }
        }
    }

    public void enqueueSocketWritable(SocketWritable socketWritable) {
        this.writeQueue.offer(socketWritable);
        if (this.informSelector.compareAndSet(true, false)) {
            this.ioSelector.addTask(this);
            this.ioSelector.wakeup();
        }
    }

    private SocketWritable poll() {
        return this.writeQueue.poll();
    }

    @Override
    public void run() {
        this.informSelector.set(true);
        if (this.ready) {
            this.handle();
        } else {
            this.registerWrite();
        }
        this.ready = false;
    }

    private void registerWrite() {
        this.registerOp(4);
    }

    @Override
    public void shutdown() {
        this.writeQueue.clear();
        while (this.poll() != null) {
        }
    }

    long getLastHandle() {
        return this.lastHandle;
    }
}

