/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.ascii.memcache;

import com.hazelcast.ascii.AbstractTextCommand;
import com.hazelcast.ascii.TextCommandConstants;
import com.hazelcast.ascii.memcache.Stats;
import com.hazelcast.nio.IOUtil;
import com.hazelcast.util.StringUtil;
import java.nio.ByteBuffer;

public class StatsCommand
extends AbstractTextCommand {
    static final byte[] STAT = StringUtil.stringToBytes("STAT ");
    static final byte[] UPTIME = StringUtil.stringToBytes("uptime ");
    static final byte[] BYTES = StringUtil.stringToBytes("bytes ");
    static final byte[] CMD_SET = StringUtil.stringToBytes("cmd_set ");
    static final byte[] CMD_GET = StringUtil.stringToBytes("cmd_get ");
    static final byte[] CMD_TOUCH = StringUtil.stringToBytes("cmd_touch ");
    static final byte[] THREADS = StringUtil.stringToBytes("threads ");
    static final byte[] WAITING_REQUESTS = StringUtil.stringToBytes("waiting_requests ");
    static final byte[] GET_HITS = StringUtil.stringToBytes("get_hits ");
    static final byte[] GET_MISSES = StringUtil.stringToBytes("get_misses ");
    static final byte[] DELETE_HITS = StringUtil.stringToBytes("delete_hits ");
    static final byte[] DELETE_MISSES = StringUtil.stringToBytes("delete_misses ");
    static final byte[] INCR_HITS = StringUtil.stringToBytes("incr_hits ");
    static final byte[] INCR_MISSES = StringUtil.stringToBytes("incr_misses ");
    static final byte[] DECR_HITS = StringUtil.stringToBytes("decr_hits ");
    static final byte[] DECR_MISSES = StringUtil.stringToBytes("decr_misses ");
    static final byte[] CURR_CONNECTIONS = StringUtil.stringToBytes("curr_connections ");
    static final byte[] TOTAL_CONNECTIONS = StringUtil.stringToBytes("total_connections ");
    ByteBuffer response;

    public StatsCommand() {
        super(TextCommandConstants.TextCommandType.STATS);
    }

    @Override
    public boolean readFrom(ByteBuffer cb) {
        return true;
    }

    public void setResponse(Stats stats) {
        this.response = ByteBuffer.allocate(1000);
        this.putInt(UPTIME, stats.uptime);
        this.putInt(THREADS, stats.threads);
        this.putInt(WAITING_REQUESTS, stats.waiting_requests);
        this.putInt(CURR_CONNECTIONS, stats.curr_connections);
        this.putInt(TOTAL_CONNECTIONS, stats.total_connections);
        this.putLong(BYTES, stats.bytes);
        this.putLong(CMD_GET, stats.cmd_get);
        this.putLong(CMD_SET, stats.cmd_set);
        this.putLong(CMD_TOUCH, stats.cmd_touch);
        this.putLong(GET_HITS, stats.get_hits);
        this.putLong(GET_MISSES, stats.get_misses);
        this.putLong(DELETE_HITS, stats.delete_hits);
        this.putLong(DELETE_MISSES, stats.delete_misses);
        this.putLong(INCR_HITS, stats.incr_hits);
        this.putLong(INCR_MISSES, stats.incr_misses);
        this.putLong(DECR_HITS, stats.decr_hits);
        this.putLong(DECR_MISSES, stats.decr_misses);
        this.response.put(END);
        this.response.flip();
    }

    private void putInt(byte[] name, int value) {
        this.response.put(STAT);
        this.response.put(name);
        this.response.put(StringUtil.stringToBytes(String.valueOf(value)));
        this.response.put(RETURN);
    }

    private void putLong(byte[] name, long value) {
        this.response.put(STAT);
        this.response.put(name);
        this.response.put(StringUtil.stringToBytes(String.valueOf(value)));
        this.response.put(RETURN);
    }

    @Override
    public boolean writeTo(ByteBuffer bb) {
        if (this.response == null) {
            this.response = ByteBuffer.allocate(0);
        }
        IOUtil.copyToHeapBuffer(this.response, bb);
        return !this.response.hasRemaining();
    }

    @Override
    public String toString() {
        return "StatsCommand{}" + super.toString();
    }
}

