/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.topic;

import com.hazelcast.spi.InternalCompletableFuture;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.OperationService;
import com.hazelcast.topic.PublishOperation;
import com.hazelcast.topic.TopicProxy;
import com.hazelcast.topic.TopicService;

public class TotalOrderedTopicProxy
extends TopicProxy {
    private final int partitionId;
    private final OperationService operationService;

    public TotalOrderedTopicProxy(String name, NodeEngine nodeEngine, TopicService service) {
        super(name, nodeEngine, service);
        this.partitionId = nodeEngine.getPartitionService().getPartitionId(this.getNameAsPartitionAwareData());
        this.operationService = nodeEngine.getOperationService();
    }

    @Override
    public void publish(Object message) {
        NodeEngine nodeEngine = this.getNodeEngine();
        PublishOperation operation = new PublishOperation(this.getName(), nodeEngine.toData(message));
        InternalCompletableFuture f = this.operationService.invokeOnPartition("hz:impl:topicService", operation, this.partitionId);
        f.getSafely();
    }
}

