/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.config;

import com.hazelcast.client.LoadBalancer;
import com.hazelcast.client.config.ClientNetworkConfig;
import com.hazelcast.client.config.ClientSecurityConfig;
import com.hazelcast.client.config.ProxyFactoryConfig;
import com.hazelcast.client.config.SocketOptions;
import com.hazelcast.config.GroupConfig;
import com.hazelcast.config.ListenerConfig;
import com.hazelcast.config.NearCacheConfig;
import com.hazelcast.config.SerializationConfig;
import com.hazelcast.config.SocketInterceptorConfig;
import com.hazelcast.core.ManagedContext;
import com.hazelcast.security.Credentials;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class ClientConfig {
    private GroupConfig groupConfig = new GroupConfig();
    private ClientSecurityConfig securityConfig = new ClientSecurityConfig();
    private ClientNetworkConfig networkConfig = new ClientNetworkConfig();
    private LoadBalancer loadBalancer;
    private List<ListenerConfig> listenerConfigs = new LinkedList<ListenerConfig>();
    private int executorPoolSize = -1;
    private SerializationConfig serializationConfig = new SerializationConfig();
    private List<ProxyFactoryConfig> proxyFactoryConfigs = new LinkedList<ProxyFactoryConfig>();
    private ManagedContext managedContext = null;
    private ClassLoader classLoader = null;
    private Map<String, NearCacheConfig> nearCacheConfigMap = new HashMap<String, NearCacheConfig>();

    public ClientSecurityConfig getSecurityConfig() {
        return this.securityConfig;
    }

    public void setSecurityConfig(ClientSecurityConfig securityConfig) {
        this.securityConfig = securityConfig;
    }

    public ClientNetworkConfig getNetworkConfig() {
        return this.networkConfig;
    }

    public void setNetworkConfig(ClientNetworkConfig networkConfig) {
        this.networkConfig = networkConfig;
    }

    public ClientConfig addNearCacheConfig(String mapName, NearCacheConfig nearCacheConfig) {
        this.nearCacheConfigMap.put(mapName, nearCacheConfig);
        return this;
    }

    public ClientConfig addListenerConfig(ListenerConfig listenerConfig) {
        this.getListenerConfigs().add(listenerConfig);
        return this;
    }

    public ClientConfig addProxyFactoryConfig(ProxyFactoryConfig proxyFactoryConfig) {
        this.proxyFactoryConfigs.add(proxyFactoryConfig);
        return this;
    }

    public NearCacheConfig getNearCacheConfig(String mapName) {
        return ClientConfig.lookupByPattern(this.nearCacheConfigMap, mapName);
    }

    public Map<String, NearCacheConfig> getNearCacheConfigMap() {
        return this.nearCacheConfigMap;
    }

    public ClientConfig setNearCacheConfigMap(Map<String, NearCacheConfig> nearCacheConfigMap) {
        this.nearCacheConfigMap = nearCacheConfigMap;
        return this;
    }

    @Deprecated
    public boolean isSmartRouting() {
        return this.networkConfig.isSmartRouting();
    }

    @Deprecated
    public ClientConfig setSmartRouting(boolean smartRouting) {
        this.networkConfig.setSmartRouting(smartRouting);
        return this;
    }

    @Deprecated
    public SocketInterceptorConfig getSocketInterceptorConfig() {
        return this.networkConfig.getSocketInterceptorConfig();
    }

    @Deprecated
    public ClientConfig setSocketInterceptorConfig(SocketInterceptorConfig socketInterceptorConfig) {
        this.networkConfig.setSocketInterceptorConfig(socketInterceptorConfig);
        return this;
    }

    @Deprecated
    public int getConnectionAttemptPeriod() {
        return this.networkConfig.getConnectionAttemptPeriod();
    }

    @Deprecated
    public ClientConfig setConnectionAttemptPeriod(int connectionAttemptPeriod) {
        this.networkConfig.setConnectionAttemptPeriod(connectionAttemptPeriod);
        return this;
    }

    @Deprecated
    public int getConnectionAttemptLimit() {
        return this.networkConfig.getConnectionAttemptLimit();
    }

    @Deprecated
    public ClientConfig setConnectionAttemptLimit(int connectionAttemptLimit) {
        this.networkConfig.setConnectionAttemptLimit(connectionAttemptLimit);
        return this;
    }

    @Deprecated
    public int getConnectionTimeout() {
        return this.networkConfig.getConnectionTimeout();
    }

    @Deprecated
    public ClientConfig setConnectionTimeout(int connectionTimeout) {
        this.networkConfig.setConnectionTimeout(connectionTimeout);
        return this;
    }

    public Credentials getCredentials() {
        return this.securityConfig.getCredentials();
    }

    public ClientConfig setCredentials(Credentials credentials) {
        this.securityConfig.setCredentials(credentials);
        return this;
    }

    @Deprecated
    public ClientConfig addAddress(String ... addresses) {
        this.networkConfig.addAddress(addresses);
        return this;
    }

    @Deprecated
    public ClientConfig setAddresses(List<String> addresses) {
        this.networkConfig.setAddresses(addresses);
        return this;
    }

    @Deprecated
    public List<String> getAddresses() {
        return this.networkConfig.getAddresses();
    }

    public GroupConfig getGroupConfig() {
        return this.groupConfig;
    }

    public ClientConfig setGroupConfig(GroupConfig groupConfig) {
        this.groupConfig = groupConfig;
        return this;
    }

    public List<ListenerConfig> getListenerConfigs() {
        return this.listenerConfigs;
    }

    public ClientConfig setListenerConfigs(List<ListenerConfig> listenerConfigs) {
        this.listenerConfigs = listenerConfigs;
        return this;
    }

    public LoadBalancer getLoadBalancer() {
        return this.loadBalancer;
    }

    public ClientConfig setLoadBalancer(LoadBalancer loadBalancer) {
        this.loadBalancer = loadBalancer;
        return this;
    }

    @Deprecated
    public boolean isRedoOperation() {
        return this.networkConfig.isRedoOperation();
    }

    @Deprecated
    public ClientConfig setRedoOperation(boolean redoOperation) {
        this.networkConfig.setRedoOperation(redoOperation);
        return this;
    }

    @Deprecated
    public SocketOptions getSocketOptions() {
        return this.networkConfig.getSocketOptions();
    }

    @Deprecated
    public ClientConfig setSocketOptions(SocketOptions socketOptions) {
        this.networkConfig.setSocketOptions(socketOptions);
        return this;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public ClientConfig setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
        return this;
    }

    public ManagedContext getManagedContext() {
        return this.managedContext;
    }

    public ClientConfig setManagedContext(ManagedContext managedContext) {
        this.managedContext = managedContext;
        return this;
    }

    public int getExecutorPoolSize() {
        return this.executorPoolSize;
    }

    public ClientConfig setExecutorPoolSize(int executorPoolSize) {
        this.executorPoolSize = executorPoolSize;
        return this;
    }

    public List<ProxyFactoryConfig> getProxyFactoryConfigs() {
        return this.proxyFactoryConfigs;
    }

    public ClientConfig setProxyFactoryConfigs(List<ProxyFactoryConfig> proxyFactoryConfigs) {
        this.proxyFactoryConfigs = proxyFactoryConfigs;
        return this;
    }

    public SerializationConfig getSerializationConfig() {
        return this.serializationConfig;
    }

    public ClientConfig setSerializationConfig(SerializationConfig serializationConfig) {
        this.serializationConfig = serializationConfig;
        return this;
    }

    private static <T> T lookupByPattern(Map<String, T> map, String name) {
        T t = map.get(name);
        if (t == null) {
            for (Map.Entry<String, T> entry : map.entrySet()) {
                String pattern = entry.getKey();
                T value = entry.getValue();
                if (!ClientConfig.nameMatches(name, pattern)) continue;
                return value;
            }
        }
        return t;
    }

    private static boolean nameMatches(String name, String pattern) {
        int index = pattern.indexOf(42);
        if (index == -1) {
            return name.equals(pattern);
        }
        String firstPart = pattern.substring(0, index);
        int indexFirstPart = name.indexOf(firstPart, 0);
        if (indexFirstPart == -1) {
            return false;
        }
        String secondPart = pattern.substring(index + 1);
        int indexSecondPart = name.indexOf(secondPart, index + 1);
        return indexSecondPart != -1;
    }
}

