/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client;

import com.hazelcast.client.HazelcastClient;
import com.hazelcast.client.connection.ClientConnectionManager;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.OutOfMemoryHandler;

public class ClientOutOfMemoryHandler
extends OutOfMemoryHandler {
    @Override
    public void onOutOfMemory(OutOfMemoryError oom, HazelcastInstance[] hazelcastInstances) {
        System.err.println(oom);
        for (HazelcastInstance instance : hazelcastInstances) {
            if (!(instance instanceof HazelcastClient)) continue;
            ClientHelper.cleanResources((HazelcastClient)instance);
        }
    }

    public static final class ClientHelper {
        private ClientHelper() {
        }

        public static void cleanResources(HazelcastClient client) {
            ClientHelper.closeSockets(client);
            ClientHelper.tryStopThreads(client);
            ClientHelper.tryShutdown(client);
        }

        private static void closeSockets(HazelcastClient client) {
            ClientConnectionManager connectionManager = client.getConnectionManager();
            if (connectionManager != null) {
                try {
                    connectionManager.shutdown();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }

        private static void tryShutdown(HazelcastClient client) {
            if (client == null) {
                return;
            }
            try {
                client.doShutdown();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        public static void tryStopThreads(HazelcastClient client) {
            if (client == null) {
                return;
            }
            try {
                client.getThreadGroup().interrupt();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

