/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.partition.impl;

import java.util.Arrays;

final class PartitionReplicaVersions {
    final int partitionId;
    final long[] versions = new long[6];

    PartitionReplicaVersions(int partitionId) {
        this.partitionId = partitionId;
    }

    long[] incrementAndGet(int backupCount) {
        int i = 0;
        while (i < backupCount) {
            int n = i++;
            this.versions[n] = this.versions[n] + 1L;
        }
        return this.versions;
    }

    long[] get() {
        return this.versions;
    }

    boolean update(long[] newVersions, int currentReplica) {
        boolean updated;
        int index = currentReplica - 1;
        long current = this.versions[index];
        long next = newVersions[index];
        boolean bl = updated = current == next - 1L;
        if (updated) {
            System.arraycopy(newVersions, 0, this.versions, 0, newVersions.length);
        }
        return updated;
    }

    void reset(long[] newVersions) {
        System.arraycopy(newVersions, 0, this.versions, 0, newVersions.length);
    }

    void clear() {
        for (int i = 0; i < this.versions.length; ++i) {
            this.versions[i] = 0L;
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("PartitionReplicaVersions");
        sb.append("{partitionId=").append(this.partitionId);
        sb.append(", versions=").append(Arrays.toString(this.versions));
        sb.append('}');
        return sb.toString();
    }
}

