/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.tx;

import com.hazelcast.core.PartitioningStrategy;
import com.hazelcast.instance.MemberImpl;
import com.hazelcast.map.MapKeySet;
import com.hazelcast.map.MapService;
import com.hazelcast.map.MapValueCollection;
import com.hazelcast.map.NearCache;
import com.hazelcast.map.QueryResult;
import com.hazelcast.map.operation.ContainsKeyOperation;
import com.hazelcast.map.operation.GetOperation;
import com.hazelcast.map.operation.MapKeySetOperation;
import com.hazelcast.map.operation.MapValuesOperation;
import com.hazelcast.map.operation.QueryOperation;
import com.hazelcast.map.operation.QueryPartitionOperation;
import com.hazelcast.map.operation.SizeOperationFactory;
import com.hazelcast.map.tx.MapTransactionLog;
import com.hazelcast.map.tx.TxnDeleteOperation;
import com.hazelcast.map.tx.TxnLockAndGetOperation;
import com.hazelcast.map.tx.TxnSetOperation;
import com.hazelcast.map.tx.TxnUnlockOperation;
import com.hazelcast.map.tx.VersionedValue;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.query.Predicate;
import com.hazelcast.spi.AbstractDistributedObject;
import com.hazelcast.spi.InternalCompletableFuture;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.OperationService;
import com.hazelcast.spi.impl.BinaryOperationFactory;
import com.hazelcast.transaction.TransactionException;
import com.hazelcast.transaction.TransactionNotActiveException;
import com.hazelcast.transaction.TransactionalObject;
import com.hazelcast.transaction.impl.Transaction;
import com.hazelcast.transaction.impl.TransactionSupport;
import com.hazelcast.util.ExceptionUtil;
import com.hazelcast.util.IterationType;
import com.hazelcast.util.QueryResultSet;
import com.hazelcast.util.ThreadUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

public abstract class TransactionalMapProxySupport
extends AbstractDistributedObject<MapService>
implements TransactionalObject {
    protected final String name;
    protected final TransactionSupport tx;
    protected final PartitioningStrategy partitionStrategy;
    protected final Map<Data, VersionedValue> valueMap = new HashMap<Data, VersionedValue>();

    public TransactionalMapProxySupport(String name, MapService mapService, NodeEngine nodeEngine, TransactionSupport transaction) {
        super(nodeEngine, mapService);
        this.name = name;
        this.tx = transaction;
        this.partitionStrategy = mapService.getMapContainer(name).getPartitioningStrategy();
    }

    protected void checkTransactionState() {
        if (!this.tx.getState().equals((Object)Transaction.State.ACTIVE)) {
            throw new TransactionNotActiveException("Transaction is not active!");
        }
    }

    public boolean containsKeyInternal(Data key) {
        ContainsKeyOperation operation = new ContainsKeyOperation(this.name, key);
        NodeEngine nodeEngine = this.getNodeEngine();
        int partitionId = nodeEngine.getPartitionService().getPartitionId(key);
        try {
            InternalCompletableFuture f = nodeEngine.getOperationService().invokeOnPartition("hz:impl:mapService", operation, partitionId);
            return (Boolean)f.get();
        }
        catch (Throwable t) {
            throw ExceptionUtil.rethrow(t);
        }
    }

    public Object getInternal(Data key) {
        Object cached;
        MapService mapService = (MapService)this.getService();
        boolean nearCacheEnabled = mapService.getMapContainer(this.name).isNearCacheEnabled();
        if (nearCacheEnabled && (cached = mapService.getFromNearCache(this.name, key)) != null) {
            if (cached.equals(NearCache.NULL_OBJECT)) {
                cached = null;
            }
            return cached;
        }
        GetOperation operation = new GetOperation(this.name, key);
        NodeEngine nodeEngine = this.getNodeEngine();
        int partitionId = nodeEngine.getPartitionService().getPartitionId(key);
        try {
            InternalCompletableFuture f = nodeEngine.getOperationService().invokeOnPartition("hz:impl:mapService", operation, partitionId);
            return f.get();
        }
        catch (Throwable t) {
            throw ExceptionUtil.rethrow(t);
        }
    }

    public Object getForUpdateInternal(Data key) {
        VersionedValue versionedValue = this.lockAndGet(key, this.tx.getTimeoutMillis());
        this.addUnlockTransactionLog(key, versionedValue.version);
        return versionedValue.value;
    }

    public int sizeInternal() {
        NodeEngine nodeEngine = this.getNodeEngine();
        try {
            Map<Integer, Object> results = nodeEngine.getOperationService().invokeOnAllPartitions("hz:impl:mapService", new SizeOperationFactory(this.name));
            int total = 0;
            for (Object result : results.values()) {
                Integer size = (Integer)((MapService)this.getService()).toObject(result);
                total += size.intValue();
            }
            return total;
        }
        catch (Throwable t) {
            throw ExceptionUtil.rethrow(t);
        }
    }

    public Data putInternal(Data key, Data value) {
        VersionedValue versionedValue = this.lockAndGet(key, this.tx.getTimeoutMillis());
        TxnSetOperation op = new TxnSetOperation(this.name, key, value, versionedValue.version);
        this.tx.addTransactionLog(new MapTransactionLog(this.name, key, op, versionedValue.version, this.tx.getOwnerUuid()));
        return versionedValue.value;
    }

    public Data putInternal(Data key, Data value, long ttl, TimeUnit timeUnit) {
        VersionedValue versionedValue = this.lockAndGet(key, this.tx.getTimeoutMillis());
        long timeInMillis = this.getTimeInMillis(ttl, timeUnit);
        TxnSetOperation op = new TxnSetOperation(this.name, key, value, versionedValue.version, timeInMillis);
        this.tx.addTransactionLog(new MapTransactionLog(this.name, key, op, versionedValue.version, this.tx.getOwnerUuid()));
        return versionedValue.value;
    }

    public Data putIfAbsentInternal(Data key, Data value) {
        VersionedValue versionedValue = this.lockAndGet(key, this.tx.getTimeoutMillis());
        if (versionedValue.value != null) {
            this.addUnlockTransactionLog(key, versionedValue.version);
            return versionedValue.value;
        }
        TxnSetOperation op = new TxnSetOperation(this.name, key, value, versionedValue.version);
        this.tx.addTransactionLog(new MapTransactionLog(this.name, key, op, versionedValue.version, this.tx.getOwnerUuid()));
        return versionedValue.value;
    }

    public Data replaceInternal(Data key, Data value) {
        VersionedValue versionedValue = this.lockAndGet(key, this.tx.getTimeoutMillis());
        if (versionedValue.value == null) {
            this.addUnlockTransactionLog(key, versionedValue.version);
            return null;
        }
        TxnSetOperation op = new TxnSetOperation(this.name, key, value, versionedValue.version);
        this.tx.addTransactionLog(new MapTransactionLog(this.name, key, op, versionedValue.version, this.tx.getOwnerUuid()));
        return versionedValue.value;
    }

    public boolean replaceIfSameInternal(Data key, Object oldValue, Data newValue) {
        VersionedValue versionedValue = this.lockAndGet(key, this.tx.getTimeoutMillis());
        if (!((MapService)this.getService()).compare(this.name, oldValue, versionedValue.value)) {
            this.addUnlockTransactionLog(key, versionedValue.version);
            return false;
        }
        TxnSetOperation op = new TxnSetOperation(this.name, key, newValue, versionedValue.version);
        this.tx.addTransactionLog(new MapTransactionLog(this.name, key, op, versionedValue.version, this.tx.getOwnerUuid()));
        return true;
    }

    public Data removeInternal(Data key) {
        VersionedValue versionedValue = this.lockAndGet(key, this.tx.getTimeoutMillis());
        this.tx.addTransactionLog(new MapTransactionLog(this.name, key, new TxnDeleteOperation(this.name, key, versionedValue.version), versionedValue.version, this.tx.getOwnerUuid()));
        return versionedValue.value;
    }

    public boolean removeIfSameInternal(Data key, Object value) {
        VersionedValue versionedValue = this.lockAndGet(key, this.tx.getTimeoutMillis());
        if (!((MapService)this.getService()).compare(this.name, versionedValue.value, value)) {
            this.addUnlockTransactionLog(key, versionedValue.version);
            return false;
        }
        this.tx.addTransactionLog(new MapTransactionLog(this.name, key, new TxnDeleteOperation(this.name, key, versionedValue.version), versionedValue.version, this.tx.getOwnerUuid()));
        return true;
    }

    private void addUnlockTransactionLog(Data key, long version) {
        TxnUnlockOperation operation = new TxnUnlockOperation(this.name, key, version);
        this.tx.addTransactionLog(new MapTransactionLog(this.name, key, operation, version, this.tx.getOwnerUuid()));
    }

    private VersionedValue lockAndGet(Data key, long timeout) {
        VersionedValue versionedValue = this.valueMap.get(key);
        if (versionedValue != null) {
            return versionedValue;
        }
        NodeEngine nodeEngine = this.getNodeEngine();
        TxnLockAndGetOperation operation = new TxnLockAndGetOperation(this.name, key, timeout, timeout, this.tx.getOwnerUuid());
        operation.setThreadId(ThreadUtil.getThreadId());
        try {
            int partitionId = nodeEngine.getPartitionService().getPartitionId(key);
            InternalCompletableFuture f = nodeEngine.getOperationService().invokeOnPartition("hz:impl:mapService", operation, partitionId);
            versionedValue = (VersionedValue)f.get();
            if (versionedValue == null) {
                throw new TransactionException("Transaction couldn't obtain lock for the key:" + ((MapService)this.getService()).toObject(key));
            }
            this.valueMap.put(key, versionedValue);
            return versionedValue;
        }
        catch (Throwable t) {
            throw ExceptionUtil.rethrow(t);
        }
    }

    protected Set<Data> keySetInternal() {
        NodeEngine nodeEngine = this.getNodeEngine();
        try {
            Map<Integer, Object> results = nodeEngine.getOperationService().invokeOnAllPartitions("hz:impl:mapService", new BinaryOperationFactory(new MapKeySetOperation(this.name), nodeEngine));
            HashSet<Data> keySet = new HashSet<Data>();
            for (Object result : results.values()) {
                Set<Data> keys = ((MapKeySet)((MapService)this.getService()).toObject(result)).getKeySet();
                keySet.addAll(keys);
            }
            return keySet;
        }
        catch (Throwable t) {
            throw ExceptionUtil.rethrow(t);
        }
    }

    protected Collection<Data> valuesInternal() {
        NodeEngine nodeEngine = this.getNodeEngine();
        try {
            Map<Integer, Object> results = nodeEngine.getOperationService().invokeOnAllPartitions("hz:impl:mapService", new BinaryOperationFactory(new MapValuesOperation(this.name), nodeEngine));
            ArrayList<Data> values = new ArrayList<Data>();
            for (Object result : results.values()) {
                values.addAll(((MapValueCollection)((MapService)this.getService()).toObject(result)).getValues());
            }
            return values;
        }
        catch (Throwable t) {
            throw ExceptionUtil.rethrow(t);
        }
    }

    protected Set queryInternal(Predicate predicate, IterationType iterationType, boolean dataResult) {
        int i;
        QueryResult queryResult;
        NodeEngine nodeEngine = this.getNodeEngine();
        OperationService operationService = nodeEngine.getOperationService();
        Collection<MemberImpl> members = nodeEngine.getClusterService().getMemberList();
        int partitionCount = nodeEngine.getPartitionService().getPartitionCount();
        HashSet<Integer> plist = new HashSet<Integer>(partitionCount);
        QueryResultSet result = new QueryResultSet(nodeEngine.getSerializationService(), iterationType, dataResult);
        ArrayList<Integer> missingList = new ArrayList<Integer>();
        try {
            ArrayList flist = new ArrayList();
            for (MemberImpl memberImpl : members) {
                InternalCompletableFuture future = operationService.invokeOnTarget("hz:impl:mapService", new QueryOperation(this.name, predicate), memberImpl.getAddress());
                flist.add(future);
            }
            for (Future future : flist) {
                List<Integer> partitionIds;
                queryResult = (QueryResult)future.get();
                if (queryResult == null || (partitionIds = queryResult.getPartitionIds()) == null) continue;
                plist.addAll(partitionIds);
                result.addAll(queryResult.getResult());
            }
            if (plist.size() == partitionCount) {
                return result;
            }
            for (i = 0; i < partitionCount; ++i) {
                if (plist.contains(i)) continue;
                missingList.add(i);
            }
        }
        catch (Throwable t) {
            missingList.clear();
            for (i = 0; i < partitionCount; ++i) {
                if (plist.contains(i)) continue;
                missingList.add(i);
            }
        }
        try {
            ArrayList futures = new ArrayList(missingList.size());
            for (Integer n : missingList) {
                QueryPartitionOperation queryPartitionOperation = new QueryPartitionOperation(this.name, predicate);
                queryPartitionOperation.setPartitionId(n);
                try {
                    InternalCompletableFuture f = operationService.invokeOnPartition("hz:impl:mapService", queryPartitionOperation, n);
                    futures.add(f);
                }
                catch (Throwable t) {
                    throw ExceptionUtil.rethrow(t);
                }
            }
            for (Future future : futures) {
                queryResult = (QueryResult)future.get();
                result.addAll(queryResult.getResult());
            }
        }
        catch (Throwable t) {
            throw ExceptionUtil.rethrow(t);
        }
        return result;
    }

    protected long getTimeInMillis(long time, TimeUnit timeunit) {
        return timeunit != null ? timeunit.toMillis(time) : time;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public final String getServiceName() {
        return "hz:impl:mapService";
    }
}

