/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map;

import com.hazelcast.logging.ILogger;
import com.hazelcast.map.MapService;
import com.hazelcast.map.operation.EvictOperation;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.InternalCompletableFuture;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.util.scheduler.EntryTaskScheduler;
import com.hazelcast.util.scheduler.ScheduledEntry;
import com.hazelcast.util.scheduler.ScheduledEntryProcessor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class EvictionProcessor
implements ScheduledEntryProcessor<Data, Object> {
    final NodeEngine nodeEngine;
    final MapService mapService;
    final String mapName;

    public EvictionProcessor(NodeEngine nodeEngine, MapService mapService, String mapName) {
        this.nodeEngine = nodeEngine;
        this.mapService = mapService;
        this.mapName = mapName;
    }

    @Override
    public void process(EntryTaskScheduler<Data, Object> scheduler, Collection<ScheduledEntry<Data, Object>> entries) {
        ArrayList futures = new ArrayList(entries.size());
        ILogger logger = this.nodeEngine.getLogger(this.getClass());
        for (ScheduledEntry<Data, Object> scheduledEntry : entries) {
            Data key = scheduledEntry.getKey();
            int partitionId = this.nodeEngine.getPartitionService().getPartitionId(key);
            if (!this.nodeEngine.getThisAddress().equals(this.nodeEngine.getPartitionService().getPartitionOwner(partitionId))) continue;
            EvictOperation operation = new EvictOperation(this.mapName, key, true);
            try {
                InternalCompletableFuture f = this.nodeEngine.getOperationService().invokeOnPartition("hz:impl:mapService", operation, partitionId);
                futures.add(f);
            }
            catch (Throwable t) {
                logger.warning(t);
            }
        }
        for (Future future : futures) {
            try {
                future.get(30L, TimeUnit.SECONDS);
            }
            catch (TimeoutException e) {
                logger.finest(e);
            }
            catch (Exception e) {
                logger.warning(e);
            }
        }
    }
}

