/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.logging;

import com.hazelcast.cluster.ClusterServiceImpl;
import com.hazelcast.instance.BuildInfo;
import com.hazelcast.instance.MemberImpl;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.LogEvent;
import com.hazelcast.logging.LogListener;
import com.hazelcast.logging.Logger;
import com.hazelcast.logging.LoggerFactory;
import com.hazelcast.logging.LoggingService;
import com.hazelcast.logging.SystemLogService;
import com.hazelcast.util.ConcurrencyUtil;
import com.hazelcast.util.ConstructorFunction;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public class LoggingServiceImpl
implements LoggingService {
    private volatile MemberImpl thisMember = new MemberImpl();
    private final SystemLogService systemLogService;
    private final String groupName;
    private final CopyOnWriteArrayList<LogListenerRegistration> listeners = new CopyOnWriteArrayList();
    private volatile String thisAddressString = "[LOCAL]";
    private final ConcurrentMap<String, ILogger> mapLoggers = new ConcurrentHashMap<String, ILogger>(100);
    private final ConstructorFunction<String, ILogger> loggerConstructor = new ConstructorFunction<String, ILogger>(){

        @Override
        public ILogger createNew(String key) {
            return new DefaultLogger(key);
        }
    };
    private final LoggerFactory loggerFactory;
    private final BuildInfo buildInfo;
    private volatile Level minLevel = Level.OFF;

    public LoggingServiceImpl(SystemLogService systemLogService, String groupName, String loggingType, BuildInfo buildInfo) {
        this.systemLogService = systemLogService;
        this.groupName = groupName;
        this.loggerFactory = Logger.newLoggerFactory(loggingType);
        this.buildInfo = buildInfo;
    }

    public void setThisMember(MemberImpl thisMember) {
        this.thisMember = thisMember;
        this.thisAddressString = "[" + thisMember.getAddress().getHost() + "]:" + thisMember.getAddress().getPort();
    }

    @Override
    public ILogger getLogger(String name) {
        return ConcurrencyUtil.getOrPutIfAbsent(this.mapLoggers, name, this.loggerConstructor);
    }

    @Override
    public ILogger getLogger(Class clazz) {
        return ConcurrencyUtil.getOrPutIfAbsent(this.mapLoggers, clazz.getName(), this.loggerConstructor);
    }

    @Override
    public void addLogListener(Level level, LogListener logListener) {
        this.listeners.add(new LogListenerRegistration(level, logListener));
        if (level.intValue() < this.minLevel.intValue()) {
            this.minLevel = level;
        }
    }

    @Override
    public void removeLogListener(LogListener logListener) {
        this.listeners.remove(new LogListenerRegistration(Level.ALL, logListener));
    }

    void handleLogEvent(LogEvent logEvent) {
        for (LogListenerRegistration logListenerRegistration : this.listeners) {
            if (logEvent.getLogRecord().getLevel().intValue() < logListenerRegistration.getLevel().intValue()) continue;
            logListenerRegistration.getLogListener().log(logEvent);
        }
    }

    private class DefaultLogger
    implements ILogger {
        final String name;
        final ILogger logger;
        final boolean addToLoggingService;

        DefaultLogger(String name) {
            this.name = name;
            this.logger = LoggingServiceImpl.this.loggerFactory.getLogger(name);
            this.addToLoggingService = name.equals(ClusterServiceImpl.class.getName());
        }

        @Override
        public void finest(String message) {
            this.log(Level.FINEST, message);
        }

        @Override
        public void finest(String message, Throwable thrown) {
            this.log(Level.FINEST, message, thrown);
        }

        @Override
        public void finest(Throwable thrown) {
            this.log(Level.FINEST, thrown.getMessage(), thrown);
        }

        @Override
        public boolean isFinestEnabled() {
            return this.isLoggable(Level.FINEST);
        }

        @Override
        public void info(String message) {
            this.log(Level.INFO, message);
        }

        @Override
        public void severe(String message) {
            this.log(Level.SEVERE, message);
        }

        @Override
        public void severe(Throwable thrown) {
            this.log(Level.SEVERE, thrown.getMessage(), thrown);
        }

        @Override
        public void severe(String message, Throwable thrown) {
            this.log(Level.SEVERE, message, thrown);
        }

        @Override
        public void warning(String message) {
            this.log(Level.WARNING, message);
        }

        @Override
        public void warning(Throwable thrown) {
            this.log(Level.WARNING, thrown.getMessage(), thrown);
        }

        @Override
        public void warning(String message, Throwable thrown) {
            this.log(Level.WARNING, message, thrown);
        }

        @Override
        public void log(Level level, String message) {
            this.log(level, message, null);
        }

        @Override
        public void log(Level level, String message, Throwable thrown) {
            boolean loggable;
            if (this.addToLoggingService) {
                LoggingServiceImpl.this.systemLogService.logNode(message + (thrown == null ? "" : ": " + thrown.getMessage()));
            }
            if ((loggable = this.logger.isLoggable(level)) || level.intValue() >= LoggingServiceImpl.this.minLevel.intValue()) {
                String logRecordMessage = LoggingServiceImpl.this.thisAddressString + " [" + LoggingServiceImpl.this.groupName + "] " + "[" + LoggingServiceImpl.this.buildInfo.getVersion() + "] " + message;
                LogRecord logRecord = new LogRecord(level, logRecordMessage);
                logRecord.setThrown(thrown);
                logRecord.setLoggerName(this.name);
                logRecord.setSourceClassName(this.name);
                LogEvent logEvent = new LogEvent(logRecord, LoggingServiceImpl.this.groupName, LoggingServiceImpl.this.thisMember);
                if (loggable) {
                    this.logger.log(logEvent);
                }
                if (LoggingServiceImpl.this.listeners.size() > 0) {
                    LoggingServiceImpl.this.handleLogEvent(logEvent);
                }
            }
        }

        @Override
        public void log(LogEvent logEvent) {
            LoggingServiceImpl.this.handleLogEvent(logEvent);
        }

        @Override
        public Level getLevel() {
            return this.logger.getLevel();
        }

        @Override
        public boolean isLoggable(Level level) {
            return this.logger.isLoggable(level);
        }
    }

    private static class LogListenerRegistration {
        final Level level;
        final LogListener logListener;

        LogListenerRegistration(Level level, LogListener logListener) {
            this.level = level;
            this.logListener = logListener;
        }

        public Level getLevel() {
            return this.level;
        }

        public LogListener getLogListener() {
            return this.logListener;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            LogListenerRegistration other = (LogListenerRegistration)obj;
            return !(this.logListener == null ? other.logListener != null : !this.logListener.equals(other.logListener));
        }

        public int hashCode() {
            return this.logListener != null ? this.logListener.hashCode() : 0;
        }
    }
}

