/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.collection.txn;

import com.hazelcast.collection.txn.CollectionPrepareOperation;
import com.hazelcast.collection.txn.CollectionRollbackOperation;
import com.hazelcast.collection.txn.CollectionTxnRemoveOperation;
import com.hazelcast.collection.txn.TransactionLogKey;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.Operation;
import com.hazelcast.transaction.impl.KeyAwareTransactionLog;
import com.hazelcast.util.ExceptionUtil;
import java.io.IOException;
import java.util.concurrent.Future;

public class CollectionTransactionLog
implements KeyAwareTransactionLog {
    private long itemId;
    private String name;
    private Operation op;
    private int partitionId;
    private String serviceName;
    String transactionId;

    public CollectionTransactionLog() {
    }

    public CollectionTransactionLog(long itemId, String name, int partitionId, String serviceName, String transactionId, Operation op) {
        this.itemId = itemId;
        this.name = name;
        this.op = op;
        this.partitionId = partitionId;
        this.serviceName = serviceName;
        this.transactionId = transactionId;
    }

    @Override
    public Object getKey() {
        return new TransactionLogKey(this.name, this.itemId, this.serviceName);
    }

    @Override
    public Future prepare(NodeEngine nodeEngine) {
        boolean removeOperation = this.op instanceof CollectionTxnRemoveOperation;
        CollectionPrepareOperation operation = new CollectionPrepareOperation(this.name, this.itemId, this.transactionId, removeOperation);
        try {
            return nodeEngine.getOperationService().invokeOnPartition(this.serviceName, operation, this.partitionId);
        }
        catch (Throwable t) {
            throw ExceptionUtil.rethrow(t);
        }
    }

    @Override
    public Future commit(NodeEngine nodeEngine) {
        try {
            return nodeEngine.getOperationService().invokeOnPartition(this.serviceName, this.op, this.partitionId);
        }
        catch (Throwable t) {
            throw ExceptionUtil.rethrow(t);
        }
    }

    @Override
    public Future rollback(NodeEngine nodeEngine) {
        boolean removeOperation = this.op instanceof CollectionTxnRemoveOperation;
        CollectionRollbackOperation operation = new CollectionRollbackOperation(this.name, this.itemId, removeOperation);
        try {
            return nodeEngine.getOperationService().invokeOnPartition(this.serviceName, operation, this.partitionId);
        }
        catch (Throwable t) {
            throw ExceptionUtil.rethrow(t);
        }
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeLong(this.itemId);
        out.writeUTF(this.name);
        out.writeInt(this.partitionId);
        out.writeUTF(this.serviceName);
        out.writeObject(this.op);
        out.writeUTF(this.transactionId);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.itemId = in.readLong();
        this.name = in.readUTF();
        this.partitionId = in.readInt();
        this.serviceName = in.readUTF();
        this.op = (Operation)in.readObject();
        this.transactionId = in.readUTF();
    }
}

