/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cluster;

import com.hazelcast.cluster.ConfigCheck;
import com.hazelcast.cluster.JoinMessage;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.DataSerializable;
import com.hazelcast.security.Credentials;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class JoinRequest
extends JoinMessage
implements DataSerializable {
    private Credentials credentials;
    private int tryCount = 0;
    private Map<String, Object> attributes;

    public JoinRequest() {
    }

    public JoinRequest(byte packetVersion, int buildNumber, Address address, String uuid, ConfigCheck config, Credentials credentials, int memberCount, int tryCount, Map<String, Object> attributes) {
        super(packetVersion, buildNumber, address, uuid, config, memberCount);
        this.credentials = credentials;
        this.tryCount = tryCount;
        this.attributes = attributes;
    }

    public Credentials getCredentials() {
        return this.credentials;
    }

    public int getTryCount() {
        return this.tryCount;
    }

    public void setTryCount(int tryCount) {
        this.tryCount = tryCount;
    }

    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        super.readData(in);
        this.credentials = (Credentials)in.readObject();
        if (this.credentials != null) {
            this.credentials.setEndpoint(this.getAddress().getHost());
        }
        this.tryCount = in.readInt();
        int size = in.readInt();
        this.attributes = new HashMap<String, Object>();
        for (int i = 0; i < size; ++i) {
            String key = in.readUTF();
            Object value = in.readObject();
            this.attributes.put(key, value);
        }
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        super.writeData(out);
        out.writeObject(this.credentials);
        out.writeInt(this.tryCount);
        out.writeInt(this.attributes.size());
        for (Map.Entry<String, Object> entry : this.attributes.entrySet()) {
            out.writeUTF(entry.getKey());
            out.writeObject(entry.getValue());
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("JoinRequest");
        sb.append("{packetVersion=").append(this.packetVersion);
        sb.append(", buildNumber=").append(this.buildNumber);
        sb.append(", address=").append(this.address);
        sb.append(", uuid='").append(this.uuid).append('\'');
        sb.append(", credentials=").append(this.credentials);
        sb.append(", memberCount=").append(this.memberCount);
        sb.append(", tryCount=").append(this.tryCount);
        sb.append('}');
        return sb.toString();
    }
}

