/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.util;

import com.hazelcast.util.IterationType;
import com.hazelcast.util.SortingUtil;
import java.util.AbstractSet;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;

public class SortedQueryResultSet
extends AbstractSet<Map.Entry> {
    private final TreeSet<Map.Entry> entries;
    private final IterationType iterationType;
    private final int pageSize;

    public SortedQueryResultSet(Comparator comparator, IterationType iterationType, int pageSize) {
        this.entries = new TreeSet<Map.Entry>(SortingUtil.newComparator(comparator, iterationType));
        this.iterationType = iterationType;
        this.pageSize = pageSize;
    }

    @Override
    public boolean add(Map.Entry entry) {
        if (this.entries.add(entry)) {
            if (this.entries.size() > this.pageSize) {
                this.entries.pollLast();
            }
            return true;
        }
        return false;
    }

    @Override
    public Iterator iterator() {
        return new SortedIterator();
    }

    public Map.Entry last() {
        if (this.entries.isEmpty()) {
            return null;
        }
        return this.entries.last();
    }

    @Override
    public int size() {
        return this.entries.size();
    }

    private class SortedIterator
    implements Iterator {
        final Iterator<Map.Entry> iter;

        private SortedIterator() {
            this.iter = SortedQueryResultSet.this.entries.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        public Object next() {
            Map.Entry entry = this.iter.next();
            if (SortedQueryResultSet.this.iterationType == IterationType.VALUE) {
                return entry.getValue();
            }
            if (SortedQueryResultSet.this.iterationType == IterationType.KEY) {
                return entry.getKey();
            }
            return entry;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

