/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.query;

import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.DataSerializable;
import com.hazelcast.nio.serialization.HazelcastSerializationException;
import com.hazelcast.query.IndexAwarePredicate;
import com.hazelcast.query.Predicate;
import com.hazelcast.query.impl.AndResultSet;
import com.hazelcast.query.impl.AttributeType;
import com.hazelcast.query.impl.ComparisonType;
import com.hazelcast.query.impl.Index;
import com.hazelcast.query.impl.IndexImpl;
import com.hazelcast.query.impl.OrResultSet;
import com.hazelcast.query.impl.QueryContext;
import com.hazelcast.query.impl.QueryException;
import com.hazelcast.query.impl.QueryableEntry;
import java.io.IOException;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class Predicates {
    private Predicates() {
    }

    public static Predicate instanceOf(Class klass) {
        return new InstanceOfPredicate(klass);
    }

    private static Comparable readAttribute(Map.Entry entry, String attribute) {
        QueryableEntry queryableEntry = (QueryableEntry)entry;
        Comparable value = queryableEntry.getAttribute(attribute);
        if (value == null) {
            return IndexImpl.NULL;
        }
        return value;
    }

    public static Predicate and(Predicate x, Predicate y) {
        return new AndPredicate(x, y);
    }

    public static Predicate not(Predicate predicate) {
        return new NotPredicate(predicate);
    }

    public static Predicate or(Predicate x, Predicate y) {
        return new OrPredicate(x, y);
    }

    public static Predicate notEqual(String attribute, Comparable y) {
        return new NotEqualPredicate(attribute, y);
    }

    public static Predicate equal(String attribute, Comparable y) {
        return new EqualPredicate(attribute, y);
    }

    public static Predicate like(String attribute, String pattern) {
        return new LikePredicate(attribute, pattern);
    }

    public static Predicate ilike(String attribute, String pattern) {
        return new ILikePredicate(attribute, pattern);
    }

    public static Predicate regex(String attribute, String pattern) {
        return new RegexPredicate(attribute, pattern);
    }

    public static Predicate greaterThan(String x, Comparable y) {
        return new GreaterLessPredicate(x, y, false, false);
    }

    public static Predicate greaterEqual(String x, Comparable y) {
        return new GreaterLessPredicate(x, y, true, false);
    }

    public static Predicate lessThan(String x, Comparable y) {
        return new GreaterLessPredicate(x, y, false, true);
    }

    public static Predicate lessEqual(String x, Comparable y) {
        return new GreaterLessPredicate(x, y, true, true);
    }

    public static Predicate between(String attribute, Comparable from, Comparable to) {
        return new BetweenPredicate(attribute, from, to);
    }

    public static Predicate in(String attribute, Comparable ... values) {
        return new InPredicate(attribute, values);
    }

    private static class InstanceOfPredicate
    implements Predicate,
    DataSerializable {
        private Class klass;

        public InstanceOfPredicate(Class klass) {
            this.klass = klass;
        }

        public boolean apply(Map.Entry mapEntry) {
            Object value = mapEntry.getValue();
            if (value == null) {
                return false;
            }
            return this.klass.isAssignableFrom(value.getClass());
        }

        @Override
        public void writeData(ObjectDataOutput out) throws IOException {
            out.writeUTF(this.klass.getName());
        }

        @Override
        public void readData(ObjectDataInput in) throws IOException {
            String klassName = in.readUTF();
            try {
                this.klass = in.getClassLoader().loadClass(klassName);
            }
            catch (ClassNotFoundException e) {
                throw new HazelcastSerializationException("Failed to load class: " + this.klass, e);
            }
        }

        public String toString() {
            return " instanceOf (" + this.klass.getName() + ")";
        }
    }

    public static abstract class AbstractPredicate
    implements IndexAwarePredicate,
    DataSerializable {
        protected String attribute;
        private volatile transient AttributeType attributeType;

        protected AbstractPredicate() {
        }

        protected AbstractPredicate(String attribute) {
            this.attribute = attribute;
        }

        protected Comparable convert(Map.Entry mapEntry, Comparable entryValue, Comparable attributeValue) {
            if (attributeValue == null) {
                return null;
            }
            if (attributeValue instanceof IndexImpl.NullObject) {
                return IndexImpl.NULL;
            }
            AttributeType type = this.attributeType;
            if (type == null) {
                QueryableEntry queryableEntry = (QueryableEntry)mapEntry;
                this.attributeType = type = queryableEntry.getAttributeType(this.attribute);
            }
            if (type == AttributeType.ENUM) {
                return type.getConverter().convert(attributeValue);
            }
            if (entryValue != null && entryValue.getClass().isAssignableFrom(attributeValue.getClass())) {
                return attributeValue;
            }
            if (type != null) {
                return type.getConverter().convert(attributeValue);
            }
            throw new QueryException("Unknown attribute type: " + attributeValue.getClass());
        }

        @Override
        public boolean isIndexed(QueryContext queryContext) {
            return this.getIndex(queryContext) != null;
        }

        protected Index getIndex(QueryContext queryContext) {
            return queryContext.getIndex(this.attribute);
        }

        protected Comparable readAttribute(Map.Entry entry) {
            QueryableEntry queryableEntry = (QueryableEntry)entry;
            Object val = queryableEntry.getAttribute(this.attribute);
            if (val != null && val.getClass().isEnum()) {
                val = val.toString();
            }
            return val;
        }

        @Override
        public void writeData(ObjectDataOutput out) throws IOException {
            out.writeUTF(this.attribute);
        }

        @Override
        public void readData(ObjectDataInput in) throws IOException {
            this.attribute = in.readUTF();
        }
    }

    public static class EqualPredicate
    extends AbstractPredicate {
        protected Comparable value;

        public EqualPredicate() {
        }

        public EqualPredicate(String attribute) {
            super(attribute);
        }

        public EqualPredicate(String attribute, Comparable value) {
            super(attribute);
            this.value = value;
        }

        @Override
        public Set<QueryableEntry> filter(QueryContext queryContext) {
            Index index = this.getIndex(queryContext);
            return index.getRecords(this.value);
        }

        public boolean apply(Map.Entry mapEntry) {
            Comparable entryValue = this.readAttribute(mapEntry);
            if (entryValue == null) {
                return this.value == null || this.value == IndexImpl.NULL;
            }
            this.value = this.convert(mapEntry, entryValue, this.value);
            return entryValue.equals(this.value);
        }

        @Override
        public void writeData(ObjectDataOutput out) throws IOException {
            super.writeData(out);
            out.writeObject(this.value);
        }

        @Override
        public void readData(ObjectDataInput in) throws IOException {
            super.readData(in);
            this.value = (Comparable)in.readObject();
        }

        public String toString() {
            return this.attribute + "=" + this.value;
        }
    }

    public static class NotEqualPredicate
    extends EqualPredicate {
        public NotEqualPredicate() {
        }

        public NotEqualPredicate(String attribute, Comparable value) {
            super(attribute, value);
        }

        @Override
        public boolean apply(Map.Entry entry) {
            return !super.apply(entry);
        }

        @Override
        public Set<QueryableEntry> filter(QueryContext queryContext) {
            Index index = this.getIndex(queryContext);
            if (index != null) {
                return index.getSubRecords(ComparisonType.NOT_EQUAL, this.value);
            }
            return null;
        }

        @Override
        public String toString() {
            return this.attribute + " != " + this.value;
        }
    }

    public static class GreaterLessPredicate
    extends EqualPredicate {
        boolean equal = false;
        boolean less = false;

        public GreaterLessPredicate() {
        }

        public GreaterLessPredicate(String attribute, Comparable value, boolean equal, boolean less) {
            super(attribute);
            if (value == null) {
                throw new NullPointerException("Arguments can't be null");
            }
            this.value = value;
            this.equal = equal;
            this.less = less;
        }

        @Override
        public boolean apply(Map.Entry mapEntry) {
            Comparable entryValue = this.readAttribute(mapEntry);
            if (entryValue == null) {
                return false;
            }
            Comparable attributeValue = this.convert(mapEntry, entryValue, this.value);
            int result = entryValue.compareTo(attributeValue);
            return this.equal && result == 0 || (this.less ? result < 0 : result > 0);
        }

        @Override
        public Set<QueryableEntry> filter(QueryContext queryContext) {
            Index index = this.getIndex(queryContext);
            ComparisonType comparisonType = this.less ? (this.equal ? ComparisonType.LESSER_EQUAL : ComparisonType.LESSER) : (this.equal ? ComparisonType.GREATER_EQUAL : ComparisonType.GREATER);
            return index.getSubRecords(comparisonType, this.value);
        }

        @Override
        public void readData(ObjectDataInput in) throws IOException {
            super.readData(in);
            this.equal = in.readBoolean();
            this.less = in.readBoolean();
        }

        @Override
        public void writeData(ObjectDataOutput out) throws IOException {
            super.writeData(out);
            out.writeBoolean(this.equal);
            out.writeBoolean(this.less);
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.attribute);
            sb.append(this.less ? "<" : ">");
            if (this.equal) {
                sb.append("=");
            }
            sb.append(this.value);
            return sb.toString();
        }
    }

    public static class OrPredicate
    implements IndexAwarePredicate,
    DataSerializable {
        private Predicate[] predicates;

        public OrPredicate() {
        }

        public OrPredicate(Predicate ... predicates) {
            this.predicates = predicates;
        }

        @Override
        public Set<QueryableEntry> filter(QueryContext queryContext) {
            LinkedList<Set<QueryableEntry>> indexedResults = new LinkedList<Set<QueryableEntry>>();
            for (Predicate predicate : this.predicates) {
                if (!(predicate instanceof IndexAwarePredicate)) continue;
                IndexAwarePredicate iap = (IndexAwarePredicate)predicate;
                if (iap.isIndexed(queryContext)) {
                    Set<QueryableEntry> s = iap.filter(queryContext);
                    if (s == null) continue;
                    indexedResults.add(s);
                    continue;
                }
                return null;
            }
            return indexedResults.isEmpty() ? null : new OrResultSet(indexedResults);
        }

        @Override
        public boolean isIndexed(QueryContext queryContext) {
            for (Predicate predicate : this.predicates) {
                if (predicate instanceof IndexAwarePredicate) {
                    IndexAwarePredicate iap = (IndexAwarePredicate)predicate;
                    if (iap.isIndexed(queryContext)) continue;
                    return false;
                }
                return false;
            }
            return true;
        }

        public boolean apply(Map.Entry mapEntry) {
            for (Predicate predicate : this.predicates) {
                if (!predicate.apply(mapEntry)) continue;
                return true;
            }
            return false;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("(");
            int size = this.predicates.length;
            for (int i = 0; i < size; ++i) {
                if (i > 0) {
                    sb.append(" OR ");
                }
                sb.append(this.predicates[i]);
            }
            sb.append(")");
            return sb.toString();
        }

        @Override
        public void writeData(ObjectDataOutput out) throws IOException {
            out.writeInt(this.predicates.length);
            for (Predicate predicate : this.predicates) {
                out.writeObject(predicate);
            }
        }

        @Override
        public void readData(ObjectDataInput in) throws IOException {
            int size = in.readInt();
            this.predicates = new Predicate[size];
            for (int i = 0; i < size; ++i) {
                this.predicates[i] = (Predicate)in.readObject();
            }
        }
    }

    public static class AndPredicate
    implements IndexAwarePredicate,
    DataSerializable {
        protected Predicate[] predicates;

        public AndPredicate() {
        }

        public AndPredicate(Predicate ... predicates) {
            this.predicates = predicates;
        }

        @Override
        public Set<QueryableEntry> filter(QueryContext queryContext) {
            Set<QueryableEntry> smallestIndexedResult = null;
            LinkedList<Set<QueryableEntry>> otherIndexedResults = new LinkedList<Set<QueryableEntry>>();
            LinkedList<Predicate> lsNoIndexPredicates = null;
            for (Predicate predicate : this.predicates) {
                boolean indexed = false;
                if (predicate instanceof IndexAwarePredicate) {
                    IndexAwarePredicate iap = (IndexAwarePredicate)predicate;
                    if (iap.isIndexed(queryContext)) {
                        indexed = true;
                        Set<QueryableEntry> s = iap.filter(queryContext);
                        if (smallestIndexedResult == null) {
                            smallestIndexedResult = s;
                        } else if (s.size() < smallestIndexedResult.size()) {
                            otherIndexedResults.add(smallestIndexedResult);
                            smallestIndexedResult = s;
                        } else {
                            otherIndexedResults.add(s);
                        }
                    } else if (lsNoIndexPredicates == null) {
                        lsNoIndexPredicates = new LinkedList();
                        lsNoIndexPredicates.add(predicate);
                    }
                }
                if (indexed) continue;
                if (lsNoIndexPredicates == null) {
                    lsNoIndexPredicates = new LinkedList<Predicate>();
                }
                lsNoIndexPredicates.add(predicate);
            }
            if (smallestIndexedResult == null) {
                return null;
            }
            return new AndResultSet(smallestIndexedResult, otherIndexedResults, lsNoIndexPredicates);
        }

        @Override
        public boolean isIndexed(QueryContext queryContext) {
            for (Predicate predicate : this.predicates) {
                IndexAwarePredicate iap;
                if (!(predicate instanceof IndexAwarePredicate) || !(iap = (IndexAwarePredicate)predicate).isIndexed(queryContext)) continue;
                return true;
            }
            return false;
        }

        public boolean apply(Map.Entry mapEntry) {
            for (Predicate predicate : this.predicates) {
                if (predicate.apply(mapEntry)) continue;
                return false;
            }
            return true;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("(");
            int size = this.predicates.length;
            for (int i = 0; i < size; ++i) {
                if (i > 0) {
                    sb.append(" AND ");
                }
                sb.append(this.predicates[i]);
            }
            sb.append(")");
            return sb.toString();
        }

        @Override
        public void writeData(ObjectDataOutput out) throws IOException {
            out.writeInt(this.predicates.length);
            for (Predicate predicate : this.predicates) {
                out.writeObject(predicate);
            }
        }

        @Override
        public void readData(ObjectDataInput in) throws IOException {
            int size = in.readInt();
            this.predicates = new Predicate[size];
            for (int i = 0; i < size; ++i) {
                this.predicates[i] = (Predicate)in.readObject();
            }
        }
    }

    public static class ILikePredicate
    extends LikePredicate {
        public ILikePredicate() {
        }

        public ILikePredicate(String attribute, String second) {
            super(attribute, second);
        }

        @Override
        public String toString() {
            StringBuilder builder = new StringBuilder(this.attribute).append(" ILIKE '").append(this.second).append("'");
            return builder.toString();
        }

        @Override
        protected int getFlags() {
            return 2;
        }
    }

    public static class LikePredicate
    implements Predicate,
    DataSerializable {
        protected String attribute;
        protected String second;
        private volatile Pattern pattern;

        public LikePredicate() {
        }

        public LikePredicate(String attribute, String second) {
            this.attribute = attribute;
            this.second = second;
        }

        public boolean apply(Map.Entry entry) {
            String firstVal;
            Comparable attribute = Predicates.readAttribute(entry, this.attribute);
            String string = firstVal = attribute == IndexImpl.NULL ? null : (String)((Object)attribute);
            if (firstVal == null) {
                return this.second == null;
            }
            if (this.second == null) {
                return false;
            }
            if (this.pattern == null) {
                String quoted = Pattern.quote(this.second);
                String regex = quoted.replaceAll("(?<!\\\\)[%]", "\\\\E.*\\\\Q").replaceAll("(?<!\\\\)[_]", "\\\\E.\\\\Q").replaceAll("\\\\%", "%").replaceAll("\\\\_", "_");
                int flags = this.getFlags();
                this.pattern = Pattern.compile(regex, flags);
            }
            Matcher m = this.pattern.matcher(firstVal);
            return m.matches();
        }

        @Override
        public void writeData(ObjectDataOutput out) throws IOException {
            out.writeUTF(this.attribute);
            out.writeUTF(this.second);
        }

        @Override
        public void readData(ObjectDataInput in) throws IOException {
            this.attribute = in.readUTF();
            this.second = in.readUTF();
        }

        public String toString() {
            StringBuilder builder = new StringBuilder(this.attribute).append(" LIKE '").append(this.second).append("'");
            return builder.toString();
        }

        protected int getFlags() {
            return 0;
        }
    }

    public static class RegexPredicate
    implements Predicate,
    DataSerializable {
        private String attribute;
        private String regex;
        private volatile Pattern pattern;

        public RegexPredicate() {
        }

        public RegexPredicate(String attribute, String regex) {
            this.attribute = attribute;
            this.regex = regex;
        }

        public boolean apply(Map.Entry entry) {
            String firstVal;
            Comparable attribute = Predicates.readAttribute(entry, this.attribute);
            String string = firstVal = attribute == IndexImpl.NULL ? null : (String)((Object)attribute);
            if (firstVal == null) {
                return this.regex == null;
            }
            if (this.regex == null) {
                return false;
            }
            if (this.pattern == null) {
                this.pattern = Pattern.compile(this.regex);
            }
            Matcher m = this.pattern.matcher(firstVal);
            return m.matches();
        }

        @Override
        public void writeData(ObjectDataOutput out) throws IOException {
            out.writeUTF(this.attribute);
            out.writeUTF(this.regex);
        }

        @Override
        public void readData(ObjectDataInput in) throws IOException {
            this.attribute = in.readUTF();
            this.regex = in.readUTF();
        }

        public String toString() {
            return this.attribute + " REGEX '" + this.regex + "'";
        }
    }

    public static class InPredicate
    extends AbstractPredicate {
        private Comparable[] values;
        private volatile Set<Comparable> convertedInValues;

        public InPredicate() {
        }

        public InPredicate(String attribute, Comparable ... values) {
            super(attribute);
            if (values == null) {
                throw new NullPointerException("Array can't be null");
            }
            for (Comparable value : values) {
                if (value != null) continue;
                throw new NullPointerException("Elements can't be null");
            }
            this.values = values;
        }

        public boolean apply(Map.Entry entry) {
            Comparable entryValue = this.readAttribute(entry);
            if (entryValue == null) {
                return false;
            }
            Set<Comparable> set = this.convertedInValues;
            if (set == null) {
                set = new HashSet<Comparable>(this.values.length);
                for (Comparable value : this.values) {
                    set.add(this.convert(entry, entryValue, value));
                }
                this.convertedInValues = set;
            }
            return set.contains(entryValue);
        }

        @Override
        public Set<QueryableEntry> filter(QueryContext queryContext) {
            Index index = this.getIndex(queryContext);
            if (index != null) {
                return index.getRecords(this.values);
            }
            return null;
        }

        @Override
        public void writeData(ObjectDataOutput out) throws IOException {
            super.writeData(out);
            out.writeInt(this.values.length);
            for (Comparable value : this.values) {
                out.writeObject(value);
            }
        }

        @Override
        public void readData(ObjectDataInput in) throws IOException {
            super.readData(in);
            int len = in.readInt();
            this.values = new Comparable[len];
            for (int i = 0; i < len; ++i) {
                this.values[i] = (Comparable)in.readObject();
            }
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.attribute);
            sb.append(" IN (");
            for (int i = 0; i < this.values.length; ++i) {
                if (i > 0) {
                    sb.append(",");
                }
                sb.append(this.values[i]);
            }
            sb.append(")");
            return sb.toString();
        }
    }

    public static class NotPredicate
    implements Predicate,
    DataSerializable {
        private Predicate predicate;

        public NotPredicate(Predicate predicate) {
            this.predicate = predicate;
        }

        public NotPredicate() {
        }

        public boolean apply(Map.Entry mapEntry) {
            return !this.predicate.apply(mapEntry);
        }

        @Override
        public void writeData(ObjectDataOutput out) throws IOException {
            out.writeObject(this.predicate);
        }

        @Override
        public void readData(ObjectDataInput in) throws IOException {
            this.predicate = (Predicate)in.readObject();
        }

        public String toString() {
            return "NOT(" + this.predicate + ")";
        }
    }

    public static class BetweenPredicate
    extends AbstractPredicate {
        private Comparable to;
        private Comparable from;

        public BetweenPredicate() {
        }

        public BetweenPredicate(String first, Comparable from, Comparable to) {
            super(first);
            if (from == null || to == null) {
                throw new NullPointerException("Arguments can't be null");
            }
            this.from = from;
            this.to = to;
        }

        public boolean apply(Map.Entry entry) {
            Comparable entryValue = this.readAttribute(entry);
            if (entryValue == null) {
                return false;
            }
            Comparable fromConvertedValue = this.convert(entry, entryValue, this.from);
            Comparable toConvertedValue = this.convert(entry, entryValue, this.to);
            if (fromConvertedValue == null || toConvertedValue == null) {
                return false;
            }
            return entryValue.compareTo(fromConvertedValue) >= 0 && entryValue.compareTo(toConvertedValue) <= 0;
        }

        @Override
        public Set<QueryableEntry> filter(QueryContext queryContext) {
            Index index = this.getIndex(queryContext);
            return index.getSubRecordsBetween(this.from, this.to);
        }

        @Override
        public void writeData(ObjectDataOutput out) throws IOException {
            super.writeData(out);
            out.writeObject(this.to);
            out.writeObject(this.from);
        }

        @Override
        public void readData(ObjectDataInput in) throws IOException {
            super.readData(in);
            this.to = (Comparable)in.readObject();
            this.from = (Comparable)in.readObject();
        }

        public String toString() {
            return this.attribute + " BETWEEN " + this.from + " AND " + this.to;
        }
    }
}

