/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.executor.client;

import com.hazelcast.client.TargetClientRequest;
import com.hazelcast.executor.ExecutorPortableHook;
import com.hazelcast.executor.MemberCallableTaskOperation;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import com.hazelcast.security.SecurityContext;
import com.hazelcast.spi.Operation;
import java.io.IOException;
import java.security.Permission;
import java.util.concurrent.Callable;

public final class TargetCallableRequest
extends TargetClientRequest {
    private String name;
    private String uuid;
    private Callable callable;
    private Address target;

    public TargetCallableRequest() {
    }

    public TargetCallableRequest(String name, String uuid, Callable callable, Address target) {
        this.name = name;
        this.uuid = uuid;
        this.callable = callable;
        this.target = target;
    }

    @Override
    protected Operation prepareOperation() {
        SecurityContext securityContext = this.getClientEngine().getSecurityContext();
        if (securityContext != null) {
            this.callable = securityContext.createSecureCallable(this.getEndpoint().getSubject(), this.callable);
        }
        return new MemberCallableTaskOperation(this.name, this.uuid, this.callable);
    }

    @Override
    public Address getTarget() {
        return this.target;
    }

    @Override
    public String getServiceName() {
        return "hz:impl:executorService";
    }

    @Override
    public int getFactoryId() {
        return ExecutorPortableHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 3;
    }

    @Override
    public void write(PortableWriter writer) throws IOException {
        writer.writeUTF("n", this.name);
        writer.writeUTF("u", this.uuid);
        ObjectDataOutput rawDataOutput = writer.getRawDataOutput();
        rawDataOutput.writeObject(this.callable);
        this.target.writeData(rawDataOutput);
    }

    @Override
    public void read(PortableReader reader) throws IOException {
        this.name = reader.readUTF("n");
        this.uuid = reader.readUTF("u");
        ObjectDataInput rawDataInput = reader.getRawDataInput();
        this.callable = (Callable)rawDataInput.readObject();
        this.target = new Address();
        this.target.readData(rawDataInput);
    }

    @Override
    public Permission getRequiredPermission() {
        return null;
    }
}

